/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.artifact.elements.JpsComplexPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsCompositePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;

public class JpsArtifactUtil {
    public static boolean processPackagingElements(@NotNull JpsPackagingElement element, @NotNull Processor<JpsPackagingElement> processor) {
        return JpsArtifactUtil.processPackagingElements(element, processor, (Set<JpsPackagingElement>)new HashSet());
    }

    private static boolean processPackagingElements(@NotNull JpsPackagingElement element, @NotNull Processor<JpsPackagingElement> processor, Set<JpsPackagingElement> processed) {
        block5: {
            block4: {
                if (!processed.add(element)) {
                    return false;
                }
                if (!processor.process((Object)element)) {
                    return false;
                }
                if (!(element instanceof JpsCompositePackagingElement)) break block4;
                for (JpsPackagingElement child : ((JpsCompositePackagingElement)element).getChildren()) {
                    JpsArtifactUtil.processPackagingElements(child, processor, processed);
                }
                break block5;
            }
            if (!(element instanceof JpsComplexPackagingElement)) break block5;
            for (JpsPackagingElement child : ((JpsComplexPackagingElement)element).getSubstitution()) {
                JpsArtifactUtil.processPackagingElements(child, processor, processed);
            }
        }
        return true;
    }

    public static boolean isArchiveName(String name) {
        return name.length() >= 4 && name.charAt(name.length() - 4) == '.' && StringUtil.endsWithIgnoreCase((String)name, (String)"ar");
    }
}

