/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac.ast;

import com.intellij.util.Consumer;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.ast.AbstractRefCollectorCompilerToolExtension;
import org.jetbrains.jps.javac.ast.api.JavacFileData;
import org.jetbrains.jps.javac.ast.api.JavacFileReferencesRegistrar;
import org.jetbrains.jps.service.JpsServiceManager;

public class InProcessRefCollectorCompilerToolExtension
extends AbstractRefCollectorCompilerToolExtension {
    protected boolean isEnabled() {
        try {
            Class<JpsServiceManager> clazz = JpsServiceManager.class;
        }
        catch (NoClassDefFoundError ignored) {
            return false;
        }
        for (JavacFileReferencesRegistrar registrar : JpsServiceManager.getInstance().getExtensions(JavacFileReferencesRegistrar.class)) {
            if (!registrar.isEnabled()) continue;
            return true;
        }
        return false;
    }

    protected boolean divideImportsRefs() {
        return false;
    }

    @NotNull
    protected Consumer<JavacFileData> getFileDataConsumer(@NotNull DiagnosticOutputConsumer diagnosticConsumer) {
        return InProcessRefCollectorCompilerToolExtension.createFileDataConsumer();
    }

    @NotNull
    static Consumer<JavacFileData> createFileDataConsumer() {
        return new JavacFileDataConsumer();
    }

    private static class JavacFileDataConsumer
    implements Consumer<JavacFileData> {
        final JavacFileReferencesRegistrar[] myRegistrars;

        private JavacFileDataConsumer() {
            ArrayList<JavacFileReferencesRegistrar> registrars = new ArrayList<JavacFileReferencesRegistrar>();
            for (JavacFileReferencesRegistrar registrar : JpsServiceManager.getInstance().getExtensions(JavacFileReferencesRegistrar.class)) {
                if (!registrar.isEnabled()) continue;
                registrar.initialize();
                registrars.add(registrar);
            }
            this.myRegistrars = registrars.toArray(new JavacFileReferencesRegistrar[registrars.size()]);
        }

        public void consume(JavacFileData data) {
            for (JavacFileReferencesRegistrar registrar : this.myRegistrars) {
                if (!registrar.isEnabled()) continue;
                registrar.registerFile(data.getFilePath(), registrar.onlyImports() ? data.getImportRefs() : data.getRefs(), data.getDefs());
            }
        }
    }
}

