/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.google.common.collect.Lists;
import com.intellij.execution.TaskExecutor;
import com.intellij.execution.configurations.EncodingEnvironmentUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessWaitFor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.HashMap;
import com.jediterm.pty.PtyProcessTtyConnector;
import com.jediterm.terminal.TtyConnector;
import com.pty4j.PtyProcess;
import com.pty4j.util.PtyUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;

public class LocalTerminalDirectRunner
extends AbstractTerminalRunner<PtyProcess> {
    private static final Logger LOG = Logger.getInstance(LocalTerminalDirectRunner.class);
    public static final String JEDITERM_USER_RCFILE = "JEDITERM_USER_RCFILE";
    public static final String ZDOTDIR = "ZDOTDIR";
    public static final String XDG_CONFIG_HOME = "XDG_CONFIG_HOME";
    private final Charset myDefaultCharset = CharsetToolkit.UTF8_CHARSET;

    public LocalTerminalDirectRunner(Project project) {
        super(project);
    }

    private static boolean hasLoginArgument(String name) {
        return name.equals("bash") || name.equals("sh") || name.equals("zsh");
    }

    private static String getShellName(String path) {
        return new File(path).getName();
    }

    private static String findRCFile(String shellName) {
        if (shellName != null) {
            if ("sh".equals(shellName)) {
                shellName = "bash";
            }
            try {
                File file;
                String rcfile = "jediterm-" + shellName + ".in";
                if ("zsh".equals(shellName)) {
                    rcfile = ".zshrc";
                } else if ("fish".equals(shellName)) {
                    rcfile = "fish/config.fish";
                }
                URL resource = LocalTerminalDirectRunner.class.getClassLoader().getResource(rcfile);
                if (resource != null && "jar".equals(resource.getProtocol()) && (file = new File(new File(PtyUtil.getJarContainingFolderPath(LocalTerminalDirectRunner.class)).getParent(), rcfile)).exists()) {
                    return file.getAbsolutePath();
                }
                if (resource != null) {
                    URI uri = resource.toURI();
                    return uri.getPath();
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to find jediterm-" + shellName + ".in configuration file", (Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    public static LocalTerminalDirectRunner createTerminalRunner(Project project) {
        return new LocalTerminalDirectRunner(project);
    }

    @Override
    protected PtyProcess createProcess(@Nullable String directory) throws ExecutionException {
        HashMap envs = new HashMap(EnvironmentUtil.getEnvironmentMap());
        if (!SystemInfo.isWindows) {
            envs.put("TERM", "xterm-256color");
        }
        EncodingEnvironmentUtil.setLocaleEnvironmentIfMac((Map)envs, (Charset)this.myDefaultCharset);
        String[] command = this.getCommand((Map<String, String>)envs);
        for (LocalTerminalCustomizer customizer : (LocalTerminalCustomizer[])LocalTerminalCustomizer.EP_NAME.getExtensions()) {
            try {
                command = customizer.customizeCommandAndEnvironment(this.myProject, command, (Map<String, String>)envs);
                if (directory != null) continue;
                directory = customizer.getDefaultFolder(this.myProject);
            }
            catch (Exception e) {
                LOG.error("Exception during customization of the terminal session", (Throwable)e);
            }
        }
        try {
            return PtyProcess.exec((String[])command, (Map)envs, (String)(directory != null ? directory : TerminalProjectOptionsProvider.Companion.getInstance(this.myProject).getStartingDirectory()));
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    protected ProcessHandler createProcessHandler(PtyProcess process) {
        return new PtyProcessHandler(process, LocalTerminalDirectRunner.getShellPath());
    }

    @Override
    protected TtyConnector createTtyConnector(PtyProcess process) {
        return new PtyProcessTtyConnector(process, this.myDefaultCharset);
    }

    @Override
    public String runningTargetName() {
        return "Local Terminal";
    }

    @Override
    protected String getTerminalConnectionName(PtyProcess process) {
        return "Local Terminal";
    }

    public String[] getCommand(Map<String, String> envs) {
        String shellPath2 = LocalTerminalDirectRunner.getShellPath();
        return LocalTerminalDirectRunner.getCommand(shellPath2, envs, TerminalOptionsProvider.Companion.getInstance().shellIntegration());
    }

    private static String getShellPath() {
        return TerminalOptionsProvider.Companion.getInstance().getShellPath();
    }

    @NotNull
    public static String[] getCommand(String shellPath2, Map<String, String> envs, boolean shellIntegration) {
        if (SystemInfo.isUnix) {
            String shellName;
            ArrayList command = Lists.newArrayList((Object[])shellPath2.split(" "));
            String shellCommand = (String)command.get(0);
            String string = shellName = command.size() > 0 ? LocalTerminalDirectRunner.getShellName(shellCommand) : null;
            if (shellName != null) {
                command.remove(0);
                ArrayList result = Lists.newArrayList((Object[])new String[]{shellCommand});
                String rcFilePath = LocalTerminalDirectRunner.findRCFile(shellName);
                if (rcFilePath != null && shellIntegration) {
                    if (shellName.equals("bash") || SystemInfo.isMac && shellName.equals("sh")) {
                        LocalTerminalDirectRunner.addRcFileArgument(envs, command, result, rcFilePath, "--rcfile");
                    } else if (shellName.equals("zsh")) {
                        String zdotdir = (String)EnvironmentUtil.getEnvironmentMap().get(ZDOTDIR);
                        if (StringUtil.isNotEmpty((String)zdotdir)) {
                            envs.put("_OLD_ZDOTDIR", zdotdir);
                            File zshRc = new File(FileUtil.expandUserHome((String)zdotdir), ".zshrc");
                            if (zshRc.exists()) {
                                envs.put(JEDITERM_USER_RCFILE, zshRc.getAbsolutePath());
                            }
                        }
                        envs.put(ZDOTDIR, new File(rcFilePath).getParent());
                    } else if (shellName.equals("fish")) {
                        String xdgConfig = (String)EnvironmentUtil.getEnvironmentMap().get(XDG_CONFIG_HOME);
                        if (StringUtil.isNotEmpty((String)xdgConfig)) {
                            File fishConfig = new File(new File(FileUtil.expandUserHome((String)xdgConfig), "fish"), "config.fish");
                            if (fishConfig.exists()) {
                                envs.put(JEDITERM_USER_RCFILE, fishConfig.getAbsolutePath());
                            }
                            envs.put("OLD_XDG_CONFIG_HOME", xdgConfig);
                        }
                        envs.put(XDG_CONFIG_HOME, new File(rcFilePath).getParentFile().getParent());
                    }
                }
                if (!LocalTerminalDirectRunner.loginOrInteractive(command)) {
                    if (LocalTerminalDirectRunner.hasLoginArgument(shellName) && SystemInfo.isMac) {
                        result.add("--login");
                    }
                    result.add("-i");
                }
                if (LocalTerminalDirectRunner.isLogin(command)) {
                    envs.put("LOGIN_SHELL", "1");
                }
                result.addAll(command);
                return ArrayUtil.toStringArray((Collection)result);
            }
            return ArrayUtil.toStringArray((Collection)command);
        }
        return new String[]{shellPath2};
    }

    private static void addRcFileArgument(Map<String, String> envs, List<String> command, List<String> result, String rcFilePath, String rcfileOption) {
        result.add(rcfileOption);
        result.add(rcFilePath);
        int idx = command.indexOf(rcfileOption);
        if (idx >= 0) {
            command.remove(idx);
            if (idx < command.size()) {
                envs.put(JEDITERM_USER_RCFILE, FileUtil.expandUserHome((String)command.get(idx)));
                command.remove(idx);
            }
        }
    }

    private static boolean loginOrInteractive(List<String> command) {
        return command.contains("-i") || LocalTerminalDirectRunner.isLogin(command);
    }

    private static boolean isLogin(List<String> command) {
        return command.contains("--login") || command.contains("-l");
    }

    private static class PtyProcessHandler
    extends ProcessHandler
    implements TaskExecutor {
        private final PtyProcess myProcess;
        private final ProcessWaitFor myWaitFor;

        public PtyProcessHandler(PtyProcess process, @NotNull String presentableName) {
            this.myProcess = process;
            this.myWaitFor = new ProcessWaitFor((Process)process, (TaskExecutor)this, presentableName);
        }

        public void startNotify() {
            this.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(ProcessEvent event) {
                    try {
                        myWaitFor.setTerminationCallback(integer -> this.notifyProcessTerminated(integer));
                    }
                    finally {
                        this.removeProcessListener((ProcessListener)this);
                    }
                }
            });
            super.startNotify();
        }

        protected void destroyProcessImpl() {
            this.myProcess.destroy();
        }

        protected void detachProcessImpl() {
            this.destroyProcessImpl();
        }

        public boolean detachIsDefault() {
            return false;
        }

        public boolean isSilentlyDestroyOnClose() {
            return true;
        }

        @Nullable
        public OutputStream getProcessInput() {
            return this.myProcess.getOutputStream();
        }

        @NotNull
        public Future<?> executeTask(@NotNull Runnable task) {
            return AppExecutorUtil.getAppExecutorService().submit(task);
        }
    }
}

