/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.cloud;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.project.Project;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.TtyConnector;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.cloud.CloudTerminalProcess;

public class CloudTerminalRunner
extends AbstractTerminalRunner<CloudTerminalProcess> {
    private final String myPipeName;
    private CloudTerminalProcess myProcess;

    public CloudTerminalRunner(@NotNull Project project, String pipeName, CloudTerminalProcess process) {
        super(project);
        this.myPipeName = pipeName;
        this.myProcess = process;
    }

    @Override
    protected CloudTerminalProcess createProcess(@Nullable String directory) throws ExecutionException {
        return this.myProcess;
    }

    @Override
    protected ProcessHandler createProcessHandler(final CloudTerminalProcess process) {
        return new ProcessHandler(){

            protected void destroyProcessImpl() {
                process.destroy();
            }

            protected void detachProcessImpl() {
                process.destroy();
            }

            public boolean detachIsDefault() {
                return false;
            }

            @Nullable
            public OutputStream getProcessInput() {
                return process.getOutputStream();
            }
        };
    }

    @Override
    protected String getTerminalConnectionName(CloudTerminalProcess process) {
        return "Terminal: " + this.myPipeName;
    }

    @Override
    protected TtyConnector createTtyConnector(CloudTerminalProcess process) {
        return new ProcessTtyConnector(process, Charset.defaultCharset()){

            protected void resizeImmediately() {
            }

            public String getName() {
                return "Connector: " + CloudTerminalRunner.this.myPipeName;
            }

            public boolean isConnected() {
                return true;
            }
        };
    }

    @Override
    public String runningTargetName() {
        return "Cloud terminal";
    }
}

