/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringValue
extends ConstantValue<String> {
    @NotNull
    private final SimpleType type;

    @Override
    @NotNull
    public SimpleType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public String toString() {
        return "\"" + (String)this.getValue() + "\"";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual(other.getClass(), this.getClass()) ^ true) {
            return false;
        }
        return Intrinsics.areEqual((Object)((String)this.getValue()), (Object)((String)((StringValue)other).getValue())) ^ true;
    }

    public int hashCode() {
        return ((String)this.getValue()).hashCode();
    }

    public StringValue(@NotNull String value, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)builtIns, (String)"builtIns");
        super(value);
        this.type = builtIns.getStringType();
    }
}

