/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality.internal.findbugs;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.quality.FindBugsReports;
import org.gradle.api.plugins.quality.internal.FindBugsReportsImpl;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsSpec;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsXmlReportImpl;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.reporting.internal.CustomizableHtmlReportImpl;
import org.gradle.api.specs.Spec;
import org.gradle.util.CollectionUtils;

public class FindBugsSpecBuilder {
    private static final Set<String> VALID_EFFORTS = ImmutableSet.of((Object)"min", (Object)"default", (Object)"max");
    private static final Set<String> VALID_REPORT_LEVELS = ImmutableSet.of((Object)"experimental", (Object)"low", (Object)"medium", (Object)"high");
    private FileCollection pluginsList;
    private FileCollection sources;
    private FileCollection classpath;
    private FileCollection classesDirs;
    private FindBugsReports reports;
    private String effort;
    private String reportLevel;
    private String maxHeapSize;
    private Collection<String> visitors;
    private Collection<String> omitVisitors;
    private File excludeFilter;
    private File includeFilter;
    private File excludeBugsFilter;
    private Collection<String> extraArgs;
    private boolean debugEnabled;

    public FindBugsSpecBuilder(FileCollection classesDirs) {
        if (classesDirs == null || classesDirs.isEmpty()) {
            throw new InvalidUserDataException("No class directories configured for FindBugs analysis.");
        }
        this.classesDirs = classesDirs;
    }

    public FindBugsSpecBuilder withPluginsList(FileCollection pluginsClasspath) {
        this.pluginsList = pluginsClasspath;
        return this;
    }

    public FindBugsSpecBuilder withSources(FileCollection sources) {
        this.sources = sources;
        return this;
    }

    public FindBugsSpecBuilder withClasspath(FileCollection classpath) {
        this.classpath = classpath;
        return this;
    }

    public FindBugsSpecBuilder configureReports(FindBugsReports reports) {
        this.reports = reports;
        return this;
    }

    public FindBugsSpecBuilder withEffort(String effort) {
        if (effort != null && !VALID_EFFORTS.contains(effort)) {
            throw new InvalidUserDataException("Invalid value for FindBugs 'effort' property: " + effort);
        }
        this.effort = effort;
        return this;
    }

    public FindBugsSpecBuilder withReportLevel(String reportLevel) {
        if (reportLevel != null && !VALID_REPORT_LEVELS.contains(reportLevel)) {
            throw new InvalidUserDataException("Invalid value for FindBugs 'reportLevel' property: " + reportLevel);
        }
        this.reportLevel = reportLevel;
        return this;
    }

    public FindBugsSpecBuilder withMaxHeapSize(String maxHeapSize) {
        this.maxHeapSize = maxHeapSize;
        return this;
    }

    public FindBugsSpecBuilder withVisitors(Collection<String> visitors) {
        this.visitors = visitors;
        return this;
    }

    public FindBugsSpecBuilder withOmitVisitors(Collection<String> omitVisitors) {
        this.omitVisitors = omitVisitors;
        return this;
    }

    public FindBugsSpecBuilder withExcludeFilter(File excludeFilter) {
        if (excludeFilter != null && !excludeFilter.canRead()) {
            String errorStr = String.format("Cannot read file specified for FindBugs 'excludeFilter' property: %s", excludeFilter);
            throw new InvalidUserDataException(errorStr);
        }
        this.excludeFilter = excludeFilter;
        return this;
    }

    public FindBugsSpecBuilder withIncludeFilter(File includeFilter) {
        if (includeFilter != null && !includeFilter.canRead()) {
            String errorStr = String.format("Cannot read file specified for FindBugs 'includeFilter' property: %s", includeFilter);
            throw new InvalidUserDataException(errorStr);
        }
        this.includeFilter = includeFilter;
        return this;
    }

    public FindBugsSpecBuilder withExcludeBugsFilter(File excludeBugsFilter) {
        if (excludeBugsFilter != null && !excludeBugsFilter.canRead()) {
            String errorStr = String.format("Cannot read file specified for FindBugs 'excludeBugsFilter' property: %s", excludeBugsFilter);
            throw new InvalidUserDataException(errorStr);
        }
        this.excludeBugsFilter = excludeBugsFilter;
        return this;
    }

    public FindBugsSpecBuilder withExtraArgs(Collection<String> extraArgs) {
        this.extraArgs = extraArgs;
        return this;
    }

    public FindBugsSpecBuilder withDebugging(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
        return this;
    }

    public FindBugsSpec build() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-pluginList");
        args.add(this.pluginsList == null ? "" : this.pluginsList.getAsPath());
        args.add("-sortByClass");
        args.add("-timestampNow");
        args.add("-progress");
        if (this.reports != null && !this.reports.getEnabled().isEmpty()) {
            if (this.reports.getEnabled().size() == 1) {
                FindBugsXmlReportImpl r;
                FindBugsReportsImpl reportsImpl = (FindBugsReportsImpl)this.reports;
                String outputArg = "-" + ((SingleFileReport)reportsImpl.getFirstEnabled()).getName();
                if (reportsImpl.getFirstEnabled() instanceof FindBugsXmlReportImpl) {
                    r = (FindBugsXmlReportImpl)reportsImpl.getFirstEnabled();
                    if (r.isWithMessages()) {
                        outputArg = outputArg + ":withMessages";
                    }
                } else if (reportsImpl.getFirstEnabled() instanceof CustomizableHtmlReportImpl && (r = (CustomizableHtmlReportImpl)reportsImpl.getFirstEnabled()).getStylesheet() != null) {
                    outputArg = outputArg + ':' + r.getStylesheet().asFile().getAbsolutePath();
                }
                args.add(outputArg);
                args.add("-outputFile");
                args.add(((SingleFileReport)reportsImpl.getFirstEnabled()).getDestination().getAbsolutePath());
            } else {
                throw new InvalidUserDataException("FindBugs tasks can only have one report enabled, however more than one report was enabled. You need to disable all but one of them.");
            }
        }
        if (this.has(this.sources)) {
            args.add("-sourcepath");
            args.add(this.sources.getAsPath());
        }
        if (this.has(this.classpath)) {
            args.add("-auxclasspath");
            args.add(this.classpath.filter((Spec)new Spec<File>(){

                public boolean isSatisfiedBy(File element) {
                    return element.exists();
                }
            }).getAsPath());
        }
        if (this.has(this.effort)) {
            args.add(String.format("-effort:%s", this.effort));
        }
        if (this.has(this.reportLevel)) {
            args.add(String.format("-%s", this.reportLevel));
        }
        if (this.has(this.visitors)) {
            args.add("-visitors");
            args.add(CollectionUtils.join((String)",", this.visitors));
        }
        if (this.has(this.omitVisitors)) {
            args.add("-omitVisitors");
            args.add(CollectionUtils.join((String)",", this.omitVisitors));
        }
        if (this.has(this.excludeFilter)) {
            args.add("-exclude");
            args.add(this.excludeFilter.getPath());
        }
        if (this.has(this.includeFilter)) {
            args.add("-include");
            args.add(this.includeFilter.getPath());
        }
        if (this.has(this.excludeBugsFilter)) {
            args.add("-excludeBugs");
            args.add(this.excludeBugsFilter.getPath());
        }
        if (this.has(this.extraArgs)) {
            args.addAll(this.extraArgs);
        }
        for (File classDir : this.classesDirs.getFiles()) {
            if (!classDir.exists()) continue;
            args.add(classDir.getAbsolutePath());
        }
        return new FindBugsSpec(args, this.maxHeapSize, this.debugEnabled);
    }

    private boolean has(String str) {
        return str != null && str.length() > 0;
    }

    private boolean has(File file) {
        return file != null && file.canRead();
    }

    private boolean has(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    private boolean has(FileCollection fileCollection) {
        return fileCollection != null && !fileCollection.isEmpty();
    }
}

