/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.ide.common.xml.XmlFormatPreferences;
import com.android.ide.common.xml.XmlFormatStyle;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.manifmerger.ActionRecorder;
import com.android.manifmerger.ElementsTrimmer;
import com.android.manifmerger.KeyResolver;
import com.android.manifmerger.ManifestProvider;
import com.android.manifmerger.ManifestSystemProperty;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.PlaceholderEncoder;
import com.android.manifmerger.PlaceholderHandler;
import com.android.manifmerger.PostValidator;
import com.android.manifmerger.PreValidator;
import com.android.manifmerger.ToolsInstructionsCleaner;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import com.android.manifmerger.XmlLoader;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.android.utils.XmlUtils;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManifestMerger2 {
    static final String BOOTSTRAP_INSTANT_RUN_CONTENT_PROVIDER = "com.android.tools.ir.server.InstantRunContentProvider";
    private final File mManifestFile;
    private final Map<String, Object> mPlaceHolderValues;
    private final PlaceholderHandler.KeyBasedValueResolver<ManifestSystemProperty> mSystemPropertyResolver;
    private final ILogger mLogger;
    private final ImmutableList<Pair<String, File>> mLibraryFiles;
    private final ImmutableList<File> mFlavorsAndBuildTypeFiles;
    private final ImmutableList<Invoker.Feature> mOptionalFeatures;
    private final MergeType mMergeType;
    private final XmlDocument.Type mDocumentType;
    private final Optional<File> mReportFile;
    private final String mFeatureName;
    private final FileStreamProvider mFileStreamProvider;

    private ManifestMerger2(ILogger logger, File mainManifestFile, ImmutableList<Pair<String, File>> libraryFiles, ImmutableList<File> flavorsAndBuildTypeFiles, ImmutableList<Invoker.Feature> optionalFeatures, Map<String, Object> placeHolderValues, PlaceholderHandler.KeyBasedValueResolver<ManifestSystemProperty> systemPropertiesResolver, MergeType mergeType, XmlDocument.Type documentType, Optional<File> reportFile, String featureName, FileStreamProvider fileStreamProvider) {
        this.mSystemPropertyResolver = systemPropertiesResolver;
        this.mPlaceHolderValues = placeHolderValues;
        this.mManifestFile = mainManifestFile;
        this.mLogger = logger;
        this.mLibraryFiles = libraryFiles;
        this.mFlavorsAndBuildTypeFiles = flavorsAndBuildTypeFiles;
        this.mOptionalFeatures = optionalFeatures;
        this.mMergeType = mergeType;
        this.mDocumentType = documentType;
        this.mReportFile = reportFile;
        this.mFeatureName = featureName;
        this.mFileStreamProvider = fileStreamProvider;
    }

    private MergingReport merge() throws MergeFailureException {
        Object mainManifestPackageName;
        MergingReport.Builder mergingReportBuilder = new MergingReport.Builder(this.mLogger, this);
        SelectorResolver selectors = new SelectorResolver();
        LoadedManifestInfo loadedMainManifestInfo = this.load(new ManifestInfo(this.mManifestFile.getName(), this.mManifestFile, this.mDocumentType, Optional.absent()), selectors, mergingReportBuilder);
        Optional<XmlAttribute> mainPackageAttribute = loadedMainManifestInfo.getXmlDocument().getPackage();
        if (this.mDocumentType != XmlDocument.Type.OVERLAY && !mainPackageAttribute.isPresent()) {
            mergingReportBuilder.addMessage(loadedMainManifestInfo.getXmlDocument().getSourceFile(), MergingReport.Record.Severity.ERROR, String.format("Main AndroidManifest.xml at %1$s manifest:package attribute is not declared", loadedMainManifestInfo.getXmlDocument().getSourceFile().print(true)));
            return mergingReportBuilder.build();
        }
        List<LoadedManifestInfo> loadedLibraryDocuments = this.loadLibraries(selectors, mergingReportBuilder, mainPackageAttribute.isPresent() ? ((XmlAttribute)mainPackageAttribute.get()).getValue() : null);
        this.performSystemPropertiesInjection(mergingReportBuilder, loadedMainManifestInfo.getXmlDocument());
        loadedMainManifestInfo = new LoadedManifestInfo(loadedMainManifestInfo, loadedMainManifestInfo.getOriginalPackageName(), loadedMainManifestInfo.getXmlDocument().reparse());
        Optional<XmlDocument> xmlDocumentOptional = Optional.absent();
        for (File inputFile : this.mFlavorsAndBuildTypeFiles) {
            this.mLogger.verbose("Merging flavors and build manifest %s \n", new Object[]{inputFile.getPath()});
            LoadedManifestInfo overlayDocument = this.load(new ManifestInfo(null, inputFile, XmlDocument.Type.OVERLAY, Optional.of((Object)((XmlAttribute)mainPackageAttribute.get()).getValue())), selectors, mergingReportBuilder);
            Optional<XmlAttribute> packageAttribute = overlayDocument.getXmlDocument().getPackage();
            if (loadedMainManifestInfo.getOriginalPackageName().isPresent() && packageAttribute.isPresent() && !((String)loadedMainManifestInfo.getOriginalPackageName().get()).equals(((XmlAttribute)packageAttribute.get()).getValue())) {
                String message = this.mMergeType == MergeType.APPLICATION ? String.format("Overlay manifest:package attribute declared at %1$s value=(%2$s)\n\thas a different value=(%3$s) declared in main manifest at %4$s\n\tSuggestion: remove the overlay declaration at %5$s \tand place it in the build.gradle:\n\t\tflavorName {\n\t\t\tapplicationId = \"%2$s\"\n\t\t}", ((XmlAttribute)packageAttribute.get()).printPosition(), ((XmlAttribute)packageAttribute.get()).getValue(), ((XmlAttribute)mainPackageAttribute.get()).getValue(), ((XmlAttribute)mainPackageAttribute.get()).printPosition(), ((XmlAttribute)packageAttribute.get()).getSourceFile().print(true)) : String.format("Overlay manifest:package attribute declared at %1$s value=(%2$s)\n\thas a different value=(%3$s) declared in main manifest at %4$s", ((XmlAttribute)packageAttribute.get()).printPosition(), ((XmlAttribute)packageAttribute.get()).getValue(), ((XmlAttribute)mainPackageAttribute.get()).getValue(), ((XmlAttribute)mainPackageAttribute.get()).printPosition());
                mergingReportBuilder.addMessage(overlayDocument.getXmlDocument().getSourceFile(), MergingReport.Record.Severity.ERROR, message);
                return mergingReportBuilder.build();
            }
            overlayDocument.getXmlDocument().getRootNode().getXml().setAttribute("package", ((XmlAttribute)mainPackageAttribute.get()).getValue());
            if ((xmlDocumentOptional = this.merge(xmlDocumentOptional, overlayDocument, mergingReportBuilder)).isPresent()) continue;
            return mergingReportBuilder.build();
        }
        this.mLogger.verbose("Merging main manifest %s\n", new Object[]{this.mManifestFile.getPath()});
        xmlDocumentOptional = this.merge(xmlDocumentOptional, loadedMainManifestInfo, mergingReportBuilder);
        if (!xmlDocumentOptional.isPresent()) {
            return mergingReportBuilder.build();
        }
        if (this.mMergeType == MergeType.LIBRARY && !Strings.isNullOrEmpty((String)(mainManifestPackageName = loadedMainManifestInfo.getXmlDocument().getRootNode().getXml().getAttribute("package")))) {
            ((XmlDocument)xmlDocumentOptional.get()).getRootNode().getXml().setAttribute("package", (String)mainManifestPackageName);
        }
        for (LoadedManifestInfo libraryDocument : loadedLibraryDocuments) {
            this.mLogger.verbose("Merging library manifest " + libraryDocument.getLocation(), new Object[0]);
            if ((xmlDocumentOptional = this.merge(xmlDocumentOptional, libraryDocument, mergingReportBuilder)).isPresent()) continue;
            return mergingReportBuilder.build();
        }
        ElementsTrimmer.trim((XmlDocument)xmlDocumentOptional.get(), mergingReportBuilder);
        if (mergingReportBuilder.hasErrors()) {
            return mergingReportBuilder.build();
        }
        if (!this.mOptionalFeatures.contains((Object)Invoker.Feature.NO_PLACEHOLDER_REPLACEMENT)) {
            MergingReport.Record.Severity severity = this.mMergeType == MergeType.LIBRARY ? MergingReport.Record.Severity.INFO : MergingReport.Record.Severity.ERROR;
            this.performPlaceHolderSubstitution(loadedMainManifestInfo, (XmlDocument)xmlDocumentOptional.get(), mergingReportBuilder, severity);
            if (mergingReportBuilder.hasErrors()) {
                return mergingReportBuilder.build();
            }
        }
        this.performSystemPropertiesInjection(mergingReportBuilder, (XmlDocument)xmlDocumentOptional.get());
        XmlDocument finalMergedDocument = (XmlDocument)xmlDocumentOptional.get();
        if (!this.mOptionalFeatures.contains((Object)Invoker.Feature.REMOVE_TOOLS_DECLARATIONS)) {
            PostValidator.enforceToolsNamespaceDeclaration(finalMergedDocument);
        }
        PostValidator.validate(finalMergedDocument, mergingReportBuilder);
        if (mergingReportBuilder.hasErrors()) {
            finalMergedDocument.getRootNode().addMessage(mergingReportBuilder, MergingReport.Record.Severity.WARNING, "Post merge validation failed");
        }
        finalMergedDocument.clearNodeNamespaces();
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.EXTRACT_FQCNS)) {
            ManifestMerger2.extractFqcns(finalMergedDocument);
        }
        this.processOptionalFeatures(finalMergedDocument.getXml(), mergingReportBuilder);
        if (!this.mOptionalFeatures.contains((Object)Invoker.Feature.SKIP_BLAME)) {
            try {
                mergingReportBuilder.setMergedDocument(MergingReport.MergedManifestKind.BLAME, mergingReportBuilder.blame(finalMergedDocument));
            }
            catch (Exception e) {
                this.mLogger.error((Throwable)e, "Error while saving blame file, build will continue", new Object[0]);
            }
        }
        mergingReportBuilder.setFinalPackageName(finalMergedDocument.getPackageName());
        mergingReportBuilder.setMergedXmlDocument(MergingReport.MergedManifestKind.MERGED, finalMergedDocument);
        MergingReport mergingReport = mergingReportBuilder.build();
        if (this.mReportFile.isPresent()) {
            this.writeReport(mergingReport);
        }
        return mergingReport;
    }

    public boolean hasFeature(Invoker.Feature feature) {
        return this.mOptionalFeatures.contains((Object)feature);
    }

    private void processOptionalFeatures(Document document, MergingReport.Builder mergingReport) {
        if (document == null) {
            return;
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.REMOVE_TOOLS_DECLARATIONS)) {
            ToolsInstructionsCleaner.cleanToolsReferences(this.mMergeType, document, this.mLogger);
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.ADVANCED_PROFILING)) {
            ManifestMerger2.addInternetPermission(document);
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.TEST_ONLY)) {
            ManifestMerger2.addTestOnlyAttribute(document);
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.DEBUGGABLE)) {
            ManifestMerger2.addDebuggableAttribute(document);
        }
        if (!this.mOptionalFeatures.contains((Object)Invoker.Feature.SKIP_XML_STRING)) {
            mergingReport.setMergedDocument(MergingReport.MergedManifestKind.MERGED, XmlPrettyPrinter.prettyPrint((Node)document, (XmlFormatPreferences)XmlFormatPreferences.defaults(), (XmlFormatStyle)XmlFormatStyle.get((Node)document.getDocumentElement()), null, (boolean)false));
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.MAKE_AAPT_SAFE)) {
            PlaceholderEncoder.visit(document);
            mergingReport.setMergedDocument(MergingReport.MergedManifestKind.AAPT_SAFE, XmlPrettyPrinter.prettyPrint((Node)document, (XmlFormatPreferences)XmlFormatPreferences.defaults(), (XmlFormatStyle)XmlFormatStyle.get((Node)document.getDocumentElement()), null, (boolean)false));
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.INSTANT_RUN_REPLACEMENT)) {
            ManifestMerger2.instantRunReplacement(document);
            mergingReport.setMergedDocument(MergingReport.MergedManifestKind.INSTANT_RUN, XmlPrettyPrinter.prettyPrint((Node)document, (XmlFormatPreferences)XmlFormatPreferences.defaults(), (XmlFormatStyle)XmlFormatStyle.get((Node)document.getDocumentElement()), null, (boolean)false));
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.ADD_FEATURE_SPLIT_INFO)) {
            ManifestMerger2.addFeatureSplitAttributes(document, this.mFeatureName);
            mergingReport.setMergedDocument(MergingReport.MergedManifestKind.MERGED, XmlPrettyPrinter.prettyPrint((Node)document, (XmlFormatPreferences)XmlFormatPreferences.defaults(), (XmlFormatStyle)XmlFormatStyle.get((Node)document.getDocumentElement()), null, (boolean)false));
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.TARGET_SANDBOX_VERSION)) {
            ManifestMerger2.addTargetSandboxVersionAttribute(document);
            mergingReport.setMergedDocument(MergingReport.MergedManifestKind.MERGED, XmlPrettyPrinter.prettyPrint((Node)document, (XmlFormatPreferences)XmlFormatPreferences.defaults(), (XmlFormatStyle)XmlFormatStyle.get((Node)document.getDocumentElement()), null, (boolean)false));
        }
    }

    private static void addTestOnlyAttribute(Document document) {
        Element manifest = document.getDocumentElement();
        ImmutableList<Element> applicationElements = ManifestMerger2.getChildElementsByName(manifest, "application");
        if (!applicationElements.isEmpty()) {
            Element application = (Element)applicationElements.get(0);
            ManifestMerger2.setAndroidAttribute(application, "testOnly", "true");
        }
    }

    private static void addDebuggableAttribute(Document document) {
        Element manifest = document.getDocumentElement();
        ImmutableList<Element> applicationElements = ManifestMerger2.getChildElementsByName(manifest, "application");
        if (!applicationElements.isEmpty()) {
            Element application = (Element)applicationElements.get(0);
            ManifestMerger2.setAndroidAttribute(application, "debuggable", "true");
        }
    }

    private static void addFeatureSplitAttributes(Document document, String featureName) {
        Element manifest = document.getDocumentElement();
        if (manifest == null) {
            return;
        }
        String attributeName = "featureSplit";
        manifest.setAttribute(attributeName, featureName);
        ImmutableList<Element> applicationElements = ManifestMerger2.getChildElementsByName(manifest, "application");
        if (applicationElements.isEmpty()) {
            return;
        }
        Element application = (Element)applicationElements.get(0);
        List<String> elementNamesToUpdate = Arrays.asList("activity", "service", "provider");
        for (String elementName : elementNamesToUpdate) {
            for (Element elementToUpdate : ManifestMerger2.getChildElementsByName(application, elementName)) {
                ManifestMerger2.setAndroidAttribute(elementToUpdate, "splitName", featureName);
            }
        }
    }

    private static void addTargetSandboxVersionAttribute(Document document) {
        Element manifest = document.getDocumentElement();
        if (manifest == null) {
            return;
        }
        ManifestMerger2.setAndroidAttribute(manifest, "targetSandboxVersion", "2");
    }

    private static void instantRunReplacement(Document document) {
        Element manifest = document.getDocumentElement();
        ImmutableList<Element> applicationElements = ManifestMerger2.getChildElementsByName(manifest, "application");
        if (applicationElements.isEmpty()) {
            throw new RuntimeException("Application not defined in AndroidManifest.xml");
        }
        Element application = (Element)applicationElements.get(0);
        ManifestMerger2.setAttributeToTrue(application, "enabled");
        ManifestMerger2.setAttributeToTrue(application, "hasCode");
        ManifestMerger2.addIrContentProvider(document, application);
    }

    private static void addInternetPermission(Document document) {
        String permission = "android.permission.INTERNET";
        Element manifest = document.getDocumentElement();
        ImmutableList<Element> usesPermissions = ManifestMerger2.getChildElementsByName(manifest, "uses-permission");
        for (Element usesPermission : usesPermissions) {
            if (!permission.equals(usesPermission.getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
            return;
        }
        Element uses = document.createElement("uses-permission");
        document.getDocumentElement().appendChild(uses);
        ManifestMerger2.setAndroidAttribute(uses, "name", permission);
    }

    private static void setAttributeToTrue(Element element, String attributeName) {
        Attr enabledAttribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName);
        if (enabledAttribute != null) {
            element.setAttributeNS("http://schemas.android.com/apk/res/android", enabledAttribute.getName(), "true");
        }
    }

    private static void addIrContentProvider(Document document, Element application) {
        Element cp = document.createElement("provider");
        ManifestMerger2.setAndroidAttribute(cp, "name", BOOTSTRAP_INSTANT_RUN_CONTENT_PROVIDER);
        String pkg = document.getDocumentElement().getAttribute("package");
        if (pkg == null) {
            throw new RuntimeException("no package name set");
        }
        ManifestMerger2.setAndroidAttribute(cp, "authorities", pkg + "." + BOOTSTRAP_INSTANT_RUN_CONTENT_PROVIDER);
        ManifestMerger2.setAndroidAttribute(cp, "multiprocess", "true");
        application.appendChild(cp);
    }

    private static void setAndroidAttribute(Element node, String localName, String value) {
        String prefix = XmlUtils.lookupNamespacePrefix((Node)node, (String)"http://schemas.android.com/apk/res/android", (String)"android", (boolean)true);
        node.setAttributeNS("http://schemas.android.com/apk/res/android", prefix + ":" + localName, value);
    }

    private static ImmutableList<Element> getChildElementsByName(Element element, String name) {
        ImmutableList.Builder childListBuilder = ImmutableList.builder();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element) || !name.equals(childNode.getNodeName())) continue;
            childListBuilder.add((Object)((Element)childNode));
        }
        return childListBuilder.build();
    }

    public FileStreamProvider getFileStreamProvider() {
        return this.mFileStreamProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeReport(MergingReport mergingReport) {
        OutputStreamWriter fileWriter = null;
        if (!((File)this.mReportFile.get()).getParentFile().exists() && !((File)this.mReportFile.get()).getParentFile().mkdirs()) {
            this.mLogger.warning(String.format("Cannot create %1$s manifest merger report file,build will continue but merging activities will not be documented", ((File)this.mReportFile.get()).getAbsolutePath()), new Object[0]);
        } else {
            fileWriter = new FileWriter((File)this.mReportFile.get());
            mergingReport.getActions().log((FileWriter)fileWriter);
        }
        if (fileWriter == null) return;
        try {
            fileWriter.close();
            return;
        }
        catch (IOException e) {
            this.mLogger.warning(String.format("Error '%1$s' while closing the merger report file, build can continue but merging activities will not be documented ", e.getMessage()), new Object[0]);
        }
        return;
        catch (IOException e) {
            try {
                this.mLogger.warning(String.format("Error '%1$s' while writing the merger report file, build can continue but merging activities will not be documented ", e.getMessage()), new Object[0]);
                if (fileWriter == null) return;
            }
            catch (Throwable throwable) {
                if (fileWriter == null) throw throwable;
                try {
                    fileWriter.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    this.mLogger.warning(String.format("Error '%1$s' while closing the merger report file, build can continue but merging activities will not be documented ", e2.getMessage()), new Object[0]);
                }
                throw throwable;
            }
            try {
                fileWriter.close();
                return;
            }
            catch (IOException e3) {
                this.mLogger.warning(String.format("Error '%1$s' while closing the merger report file, build can continue but merging activities will not be documented ", e3.getMessage()), new Object[0]);
            }
            return;
        }
    }

    private static void extractFqcns(XmlDocument finalMergedDocument) {
        ManifestMerger2.extractFqcns(finalMergedDocument.getPackageName(), finalMergedDocument.getRootNode());
    }

    private static void extractFqcns(String packageName, XmlElement xmlElement) {
        for (XmlAttribute xmlAttribute : xmlElement.getAttributes()) {
            String value;
            if (xmlAttribute.getModel() == null || !xmlAttribute.getModel().isPackageDependent() || !(value = xmlAttribute.getValue()).startsWith(packageName) || value.charAt(packageName.length()) != '.') continue;
            xmlAttribute.getXml().setValue(value.substring(packageName.length()));
        }
        for (XmlElement child : xmlElement.getMergeableElements()) {
            ManifestMerger2.extractFqcns(packageName, child);
        }
    }

    private LoadedManifestInfo load(ManifestInfo manifestInfo, KeyResolver<String> selectors, MergingReport.Builder mergingReportBuilder) throws MergeFailureException {
        XmlDocument xmlDocument;
        File xmlFile = manifestInfo.mLocation;
        try {
            InputStream inputStream = this.mFileStreamProvider.getInputStream(xmlFile);
            xmlDocument = XmlLoader.load(selectors, this.mSystemPropertyResolver, manifestInfo.mName, xmlFile, inputStream, manifestInfo.getType(), manifestInfo.getMainManifestPackageName());
        }
        catch (Exception e) {
            throw new MergeFailureException(e);
        }
        String originalPackageName = xmlDocument.getPackageName();
        MergingReport.Builder builder = manifestInfo.getType() == XmlDocument.Type.MAIN ? mergingReportBuilder : new MergingReport.Builder(mergingReportBuilder.getLogger(), this);
        ManifestInfo updatedManifestInfo = manifestInfo.getType() == XmlDocument.Type.MAIN ? new ManifestInfo(manifestInfo.getName(), manifestInfo.getLocation(), manifestInfo.getType(), Optional.of((Object)originalPackageName)) : manifestInfo;
        MergingReport.Record.Severity severity = this.mMergeType == MergeType.LIBRARY ? MergingReport.Record.Severity.INFO : MergingReport.Record.Severity.ERROR;
        this.performPlaceHolderSubstitution(updatedManifestInfo, xmlDocument, builder, severity);
        builder.getActionRecorder().recordAddedNodeAction(xmlDocument.getRootNode(), false);
        return new LoadedManifestInfo(updatedManifestInfo, Optional.fromNullable((Object)originalPackageName), xmlDocument);
    }

    private void performPlaceHolderSubstitution(ManifestInfo manifestInfo, XmlDocument xmlDocument, MergingReport.Builder mergingReportBuilder, MergingReport.Record.Severity severity) {
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.NO_PLACEHOLDER_REPLACEMENT)) {
            return;
        }
        ImmutableMap finalPlaceHolderValues = this.mPlaceHolderValues;
        if (!this.mPlaceHolderValues.containsKey("applicationId") && this.mMergeType != MergeType.LIBRARY && manifestInfo.getMainManifestPackageName().isPresent()) {
            String packageName = (String)manifestInfo.getMainManifestPackageName().get();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<String, Object> entry : this.mPlaceHolderValues.entrySet()) {
                if (entry.getKey().equals("packageName")) continue;
                builder.put(entry);
            }
            builder.put((Object)"packageName", (Object)packageName);
            builder.put((Object)"applicationId", (Object)packageName);
            finalPlaceHolderValues = builder.build();
        }
        MapBasedKeyBasedValueResolver<String> placeHolderValueResolver = new MapBasedKeyBasedValueResolver<String>((Map<String, Object>)finalPlaceHolderValues);
        PlaceholderHandler.visit(severity, xmlDocument, placeHolderValueResolver, mergingReportBuilder);
    }

    private Optional<XmlDocument> merge(Optional<XmlDocument> xmlDocument, LoadedManifestInfo lowerPriorityDocument, MergingReport.Builder mergingReportBuilder) throws MergeFailureException {
        Optional<XmlDocument> result;
        MergingReport.Result validationResult = PreValidator.validate(mergingReportBuilder, lowerPriorityDocument.getXmlDocument());
        if (validationResult == MergingReport.Result.ERROR) {
            mergingReportBuilder.addMessage(lowerPriorityDocument.getXmlDocument().getSourceFile(), MergingReport.Record.Severity.ERROR, "Validation failed, exiting");
            return Optional.absent();
        }
        if (xmlDocument.isPresent()) {
            result = ((XmlDocument)xmlDocument.get()).merge(lowerPriorityDocument.getXmlDocument(), mergingReportBuilder, !this.mOptionalFeatures.contains((Object)Invoker.Feature.NO_IMPLICIT_PERMISSION_ADDITION));
        } else {
            mergingReportBuilder.getActionRecorder().recordAddedNodeAction(lowerPriorityDocument.getXmlDocument().getRootNode(), true);
            result = Optional.of((Object)lowerPriorityDocument.getXmlDocument());
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.KEEP_INTERMEDIARY_STAGES) && result.isPresent()) {
            mergingReportBuilder.addMergingStage(((XmlDocument)result.get()).prettyPrint());
        }
        return result;
    }

    private List<LoadedManifestInfo> loadLibraries(SelectorResolver selectors, MergingReport.Builder mergingReportBuilder, String mainManifestPackageName) throws MergeFailureException {
        ImmutableList.Builder loadedLibraryDocuments = ImmutableList.builder();
        for (Pair libraryFile : Sets.newLinkedHashSet(this.mLibraryFiles)) {
            XmlDocument libraryDocument;
            this.mLogger.verbose("Loading library manifest " + ((File)libraryFile.getSecond()).getPath(), new Object[0]);
            ManifestInfo manifestInfo = new ManifestInfo((String)libraryFile.getFirst(), (File)libraryFile.getSecond(), XmlDocument.Type.LIBRARY, Optional.fromNullable((Object)mainManifestPackageName));
            File xmlFile = manifestInfo.mLocation;
            try {
                InputStream inputStream = this.mFileStreamProvider.getInputStream(xmlFile);
                libraryDocument = XmlLoader.load(selectors, this.mSystemPropertyResolver, manifestInfo.mName, xmlFile, inputStream, XmlDocument.Type.LIBRARY, (Optional<String>)Optional.absent());
            }
            catch (Exception e) {
                throw new MergeFailureException(e);
            }
            String libraryPackage = libraryDocument.getRootNode().getXml().getAttribute("package");
            if (!Strings.isNullOrEmpty((String)libraryPackage)) {
                selectors.addSelector(libraryPackage, (String)libraryFile.getFirst());
            }
            MergingReport.Builder builder = new MergingReport.Builder(mergingReportBuilder.getLogger(), this);
            builder.getActionRecorder().recordAddedNodeAction(libraryDocument.getRootNode(), false);
            this.performPlaceHolderSubstitution(manifestInfo, libraryDocument, builder, MergingReport.Record.Severity.INFO);
            if (builder.hasErrors()) {
                builder.build().log(this.mLogger);
            }
            loadedLibraryDocuments.add((Object)new LoadedManifestInfo(manifestInfo, Optional.fromNullable((Object)libraryDocument.getPackageName()), libraryDocument));
        }
        return loadedLibraryDocuments.build();
    }

    public static Invoker newMerger(File mainManifestFile, ILogger logger, MergeType mergeType) {
        return new Invoker(mainManifestFile, logger, mergeType, XmlDocument.Type.MAIN);
    }

    protected void performSystemPropertiesInjection(MergingReport.Builder mergingReport, XmlDocument xmlDocument) {
        for (ManifestSystemProperty manifestSystemProperty : ManifestSystemProperty.values()) {
            String propertyOverride = this.mSystemPropertyResolver.getValue(manifestSystemProperty);
            if (propertyOverride == null) continue;
            manifestSystemProperty.addTo(mergingReport.getActionRecorder(), xmlDocument, propertyOverride);
        }
    }

    public static class MergeFailureException
    extends Exception {
        protected MergeFailureException(Exception cause) {
            super(cause);
        }
    }

    static class SelectorResolver
    implements KeyResolver<String> {
        private final Map<String, String> mSelectors = new HashMap<String, String>();

        SelectorResolver() {
        }

        protected void addSelector(String key, String value) {
            this.mSelectors.put(key, value);
        }

        @Override
        public String resolve(String key) {
            return this.mSelectors.get(key);
        }

        @Override
        public Iterable<String> getKeys() {
            return this.mSelectors.keySet();
        }
    }

    private static class LoadedManifestInfo
    extends ManifestInfo {
        private final XmlDocument mXmlDocument;
        private final Optional<String> mOriginalPackageName;

        private LoadedManifestInfo(ManifestInfo manifestInfo, Optional<String> originalPackageName, XmlDocument xmlDocument) {
            super(manifestInfo.mName, manifestInfo.mLocation, manifestInfo.mType, manifestInfo.getMainManifestPackageName());
            this.mXmlDocument = xmlDocument;
            this.mOriginalPackageName = originalPackageName;
        }

        public XmlDocument getXmlDocument() {
            return this.mXmlDocument;
        }

        public Optional<String> getOriginalPackageName() {
            return this.mOriginalPackageName;
        }
    }

    private static class ManifestInfo {
        private final String mName;
        private final File mLocation;
        private final XmlDocument.Type mType;
        private final Optional<String> mMainManifestPackageName;

        private ManifestInfo(String name, File location, XmlDocument.Type type, Optional<String> mainManifestPackageName) {
            this.mName = name;
            this.mLocation = location;
            this.mType = type;
            this.mMainManifestPackageName = mainManifestPackageName;
        }

        String getName() {
            return this.mName;
        }

        File getLocation() {
            return this.mLocation;
        }

        XmlDocument.Type getType() {
            return this.mType;
        }

        Optional<String> getMainManifestPackageName() {
            return this.mMainManifestPackageName;
        }
    }

    public static class MapBasedKeyBasedValueResolver<T>
    implements PlaceholderHandler.KeyBasedValueResolver<T> {
        private final ImmutableMap<T, Object> keyValues;

        public MapBasedKeyBasedValueResolver(Map<T, Object> keyValues) {
            this.keyValues = ImmutableMap.copyOf(keyValues);
        }

        @Override
        public String getValue(T key) {
            Object value = this.keyValues.get(key);
            return value == null ? null : value.toString();
        }
    }

    public static class Invoker<T extends Invoker<T>> {
        protected final File mMainManifestFile;
        protected final ImmutableMap.Builder<ManifestSystemProperty, Object> mSystemProperties = new ImmutableMap.Builder();
        protected final ILogger mLogger;
        protected final ImmutableMap.Builder<String, Object> mPlaceholders = new ImmutableMap.Builder();
        private final ImmutableList.Builder<Pair<String, File>> mLibraryFilesBuilder = new ImmutableList.Builder();
        private final ImmutableList.Builder<File> mFlavorsAndBuildTypeFiles = new ImmutableList.Builder();
        private final ImmutableList.Builder<Feature> mFeaturesBuilder = new ImmutableList.Builder();
        private final MergeType mMergeType;
        private XmlDocument.Type mDocumentType;
        private File mReportFile;
        private FileStreamProvider mFileStreamProvider;
        private String mFeatureName;
        private static final Pattern FEATURE_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9][a-zA-Z0-9_]*");

        public Invoker setOverride(ManifestSystemProperty override, String value) {
            this.mSystemProperties.put((Object)override, (Object)value);
            return this.thisAsT();
        }

        public Invoker setPlaceHolderValues(Map<String, Object> keyValuePairs) {
            this.mPlaceholders.putAll(keyValuePairs);
            return this.thisAsT();
        }

        public Invoker setPlaceHolderValue(String placeHolderName, String value) {
            this.mPlaceholders.put((Object)placeHolderName, (Object)value);
            return this.thisAsT();
        }

        private Invoker(File mainManifestFile, ILogger logger, MergeType mergeType, XmlDocument.Type documentType) {
            this.mMainManifestFile = (File)Preconditions.checkNotNull((Object)mainManifestFile);
            this.mLogger = logger;
            this.mMergeType = mergeType;
            this.mDocumentType = documentType;
            this.mFeatureName = "";
        }

        public Invoker setMergeReportFile(File mergeReport) {
            this.mReportFile = mergeReport;
            return this;
        }

        public Invoker addLibraryManifest(File file) {
            this.addLibraryManifest(file.getName(), file);
            return this.thisAsT();
        }

        public Invoker addLibraryManifest(String name, File file) {
            if (this.mMergeType == MergeType.LIBRARY) {
                throw new IllegalStateException("Cannot add library dependencies manifests when creating a library");
            }
            this.mLibraryFilesBuilder.add((Object)Pair.of((Object)name, (Object)file));
            return this.thisAsT();
        }

        @Deprecated
        public Invoker addBundleManifests(List<Pair<String, File>> namesAndFiles) {
            if (this.mMergeType == MergeType.LIBRARY && !namesAndFiles.isEmpty()) {
                throw new IllegalStateException("Cannot add library dependencies manifests when creating a library");
            }
            this.mLibraryFilesBuilder.addAll(namesAndFiles);
            return this.thisAsT();
        }

        public Invoker addManifestProviders(Iterable<? extends ManifestProvider> providers) {
            for (ManifestProvider manifestProvider : providers) {
                this.mLibraryFilesBuilder.add((Object)Pair.of((Object)manifestProvider.getName(), (Object)manifestProvider.getManifest()));
            }
            return this.thisAsT();
        }

        public Invoker addLibraryManifests(File ... files) {
            for (File file : files) {
                this.addLibraryManifest(file);
            }
            return this.thisAsT();
        }

        public Invoker addFlavorAndBuildTypeManifest(File file) {
            this.mFlavorsAndBuildTypeFiles.add((Object)file);
            return this.thisAsT();
        }

        public Invoker addFlavorAndBuildTypeManifests(File ... files) {
            this.mFlavorsAndBuildTypeFiles.add((Object[])files);
            return this.thisAsT();
        }

        public Invoker withFeatures(Feature ... features) {
            this.mFeaturesBuilder.add((Object[])features);
            return this.thisAsT();
        }

        public Invoker withFileStreamProvider(FileStreamProvider provider) {
            assert (this.mFileStreamProvider == null || provider == null);
            this.mFileStreamProvider = provider;
            return this.thisAsT();
        }

        public Invoker setFeatureName(String featureName) {
            if (featureName != null) {
                this.mFeatureName = featureName;
                if (!FEATURE_NAME_PATTERN.matcher(this.mFeatureName).matches()) {
                    throw new IllegalArgumentException("FeatureName must follow " + FEATURE_NAME_PATTERN.pattern() + " regex, found " + featureName);
                }
            }
            return this.thisAsT();
        }

        public Invoker asType(XmlDocument.Type type) {
            this.mDocumentType = type;
            return this;
        }

        public MergingReport merge() throws MergeFailureException {
            ImmutableMap systemProperties = this.mSystemProperties.build();
            if (systemProperties.containsKey((Object)ManifestSystemProperty.PACKAGE)) {
                this.mPlaceholders.put((Object)"packageName", systemProperties.get((Object)ManifestSystemProperty.PACKAGE));
                if (this.mMergeType != MergeType.LIBRARY) {
                    this.mPlaceholders.put((Object)"applicationId", systemProperties.get((Object)ManifestSystemProperty.PACKAGE));
                }
            }
            FileStreamProvider fileStreamProvider = this.mFileStreamProvider != null ? this.mFileStreamProvider : new FileStreamProvider();
            ManifestMerger2 manifestMerger = new ManifestMerger2(this.mLogger, this.mMainManifestFile, this.mLibraryFilesBuilder.build(), this.mFlavorsAndBuildTypeFiles.build(), this.mFeaturesBuilder.build(), (Map)this.mPlaceholders.build(), new MapBasedKeyBasedValueResolver(systemProperties), this.mMergeType, this.mDocumentType, Optional.fromNullable((Object)this.mReportFile), this.mFeatureName, fileStreamProvider);
            return manifestMerger.merge();
        }

        private T thisAsT() {
            return (T)this;
        }

        public static enum Feature {
            KEEP_INTERMEDIARY_STAGES,
            PRINT_SIMPLE_FILENAMES,
            EXTRACT_FQCNS,
            REMOVE_TOOLS_DECLARATIONS,
            NO_PLACEHOLDER_REPLACEMENT,
            MAKE_AAPT_SAFE,
            INSTANT_RUN_REPLACEMENT,
            SKIP_BLAME,
            SKIP_XML_STRING,
            TEST_ONLY,
            NO_IMPLICIT_PERMISSION_ADDITION,
            ADVANCED_PROFILING,
            ADD_FEATURE_SPLIT_INFO,
            DEBUGGABLE,
            TARGET_SANDBOX_VERSION,
            HANDLE_VALUE_CONFLICTS_AUTOMATICALLY;

        }
    }

    public static class FileStreamProvider {
        protected InputStream getInputStream(File file) throws FileNotFoundException {
            return new BufferedInputStream(new FileInputStream(file));
        }
    }

    public static interface AutoAddingProperty {
        public void addTo(ActionRecorder var1, XmlDocument var2, String var3);
    }

    public static enum MergeType {
        APPLICATION,
        LIBRARY;

    }
}

