/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.util.net.IdeHttpClientHelpers;
import com.intellij.util.net.ssl.CertificateManager;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubSettings;

class GithubConnectionBuilder {
    @NotNull
    private final GithubAuthData myAuth;
    @NotNull
    private final String myApiURL;

    public GithubConnectionBuilder(@NotNull GithubAuthData auth, @NotNull String apiURL) {
        this.myAuth = auth;
        this.myApiURL = apiURL;
    }

    @NotNull
    public CloseableHttpClient createClient() {
        HttpClientBuilder builder = HttpClients.custom();
        builder.setDefaultRequestConfig(this.createRequestConfig()).setDefaultConnectionConfig(this.createConnectionConfig()).setDefaultHeaders(this.createHeaders()).setSslcontext(CertificateManager.getInstance().getSslContext());
        this.setupCredentialsProvider(builder);
        return builder.build();
    }

    @NotNull
    private RequestConfig createRequestConfig() {
        RequestConfig.Builder builder = RequestConfig.custom();
        int timeout = GithubSettings.getInstance().getConnectionTimeout();
        builder.setConnectTimeout(timeout).setSocketTimeout(timeout);
        if (this.myAuth.isUseProxy()) {
            IdeHttpClientHelpers.ApacheHttpClient4.setProxyForUrlIfEnabled((RequestConfig.Builder)builder, (String)this.myApiURL);
        }
        return builder.build();
    }

    @NotNull
    private ConnectionConfig createConnectionConfig() {
        return ConnectionConfig.custom().setCharset(Consts.UTF_8).build();
    }

    @NotNull
    private CredentialsProvider setupCredentialsProvider(@NotNull HttpClientBuilder builder) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        GithubAuthData.BasicAuth basicAuth = this.myAuth.getBasicAuth();
        if (basicAuth != null) {
            AuthScope authScope = this.getBasicAuthScope();
            provider.setCredentials(authScope, (Credentials)new UsernamePasswordCredentials(basicAuth.getLogin(), basicAuth.getPassword()));
            builder.addInterceptorFirst((HttpRequestInterceptor)new PreemptiveBasicAuthInterceptor(authScope));
        }
        builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        if (this.myAuth.isUseProxy()) {
            IdeHttpClientHelpers.ApacheHttpClient4.setProxyCredentialsForUrlIfEnabled((CredentialsProvider)provider, (String)this.myApiURL);
        }
        return provider;
    }

    @NotNull
    private AuthScope getBasicAuthScope() {
        try {
            URIBuilder builder = new URIBuilder(this.myApiURL);
            return new AuthScope(builder.getHost(), builder.getPort(), AuthScope.ANY_REALM, "Basic");
        }
        catch (URISyntaxException e) {
            return AuthScope.ANY;
        }
    }

    @NotNull
    private Collection<? extends Header> createHeaders() {
        GithubAuthData.BasicAuth basicAuth;
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        GithubAuthData.TokenAuth tokenAuth = this.myAuth.getTokenAuth();
        if (tokenAuth != null) {
            headers.add(new BasicHeader("Authorization", "token " + tokenAuth.getToken()));
        }
        if ((basicAuth = this.myAuth.getBasicAuth()) != null && basicAuth.getCode() != null) {
            headers.add(new BasicHeader("X-GitHub-OTP", basicAuth.getCode()));
        }
        return headers;
    }

    private static class PreemptiveBasicAuthInterceptor
    implements HttpRequestInterceptor {
        @NotNull
        private final AuthScope myBasicAuthScope;

        public PreemptiveBasicAuthInterceptor(@NotNull AuthScope basicAuthScope) {
            this.myBasicAuthScope = basicAuthScope;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            CredentialsProvider provider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
            Credentials credentials = provider.getCredentials(this.myBasicAuthScope);
            if (credentials != null) {
                request.addHeader(new BasicScheme(Consts.UTF_8).authenticate(credentials, request, context));
            }
        }
    }
}

