/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.data;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.mandatory.Mandatory;
import org.jetbrains.io.mandatory.RestModel;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.api.data.GithubUser;

@RestModel
public class GithubPullRequest {
    @Mandatory
    private Long number;
    @Mandatory
    private String state;
    @Mandatory
    private String title;
    private String body;
    private String bodyHtml;
    private String url;
    @Mandatory
    private String htmlUrl;
    @Mandatory
    private String diffUrl;
    @Mandatory
    private String patchUrl;
    @Mandatory
    private String issueUrl;
    private Boolean merged;
    private Boolean mergeable;
    private Integer comments;
    private Integer commits;
    private Integer additions;
    private Integer deletions;
    private Integer changedFiles;
    @Mandatory
    private Date createdAt;
    @Mandatory
    private Date updatedAt;
    private Date closedAt;
    private Date mergedAt;
    @Mandatory
    private GithubUser user;
    @Mandatory
    private Link head;
    @Mandatory
    private Link base;

    public long getNumber() {
        return this.number;
    }

    @NotNull
    public String getState() {
        return this.state;
    }

    @NotNull
    public String getTitle() {
        return this.title;
    }

    @NotNull
    public String getBodyHtml() {
        return StringUtil.notNullize((String)this.bodyHtml);
    }

    @NotNull
    public String getHtmlUrl() {
        return this.htmlUrl;
    }

    @NotNull
    public String getDiffUrl() {
        return this.diffUrl;
    }

    @NotNull
    public String getPatchUrl() {
        return this.patchUrl;
    }

    @NotNull
    public String getIssueUrl() {
        return this.issueUrl;
    }

    @NotNull
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @NotNull
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Nullable
    public Date getClosedAt() {
        return this.closedAt;
    }

    @Nullable
    public Date getMergedAt() {
        return this.mergedAt;
    }

    @NotNull
    public GithubUser getUser() {
        return this.user;
    }

    @NotNull
    public Link getHead() {
        return this.head;
    }

    @NotNull
    public Link getBase() {
        return this.base;
    }

    @RestModel
    public static class Link {
        @Mandatory
        private String label;
        @Mandatory
        private String ref;
        @Mandatory
        private String sha;
        private GithubRepo repo;
        @Mandatory
        private GithubUser user;

        @NotNull
        public String getLabel() {
            return this.label;
        }

        @NotNull
        public String getRef() {
            return this.ref;
        }

        @NotNull
        public String getSha() {
            return this.sha;
        }

        @Nullable
        public GithubRepo getRepo() {
            return this.repo;
        }

        @NotNull
        public GithubUser getUser() {
            return this.user;
        }
    }
}

