/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.data;

import com.google.gson.annotations.SerializedName;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.mandatory.Mandatory;
import org.jetbrains.io.mandatory.RestModel;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.api.data.GithubUser;

@RestModel
public class GithubRepo {
    private Long id;
    @Mandatory
    private String name;
    private String fullName;
    private String description;
    @SerializedName(value="private")
    @Mandatory
    private Boolean isPrivate;
    @SerializedName(value="fork")
    @Mandatory
    private Boolean isFork;
    private String url;
    @Mandatory
    private String htmlUrl;
    @Mandatory
    private String cloneUrl;
    private String gitUrl;
    private String sshUrl;
    private String svnUrl;
    private String mirrorUrl;
    private String homepage;
    private String language;
    private Integer size;
    private Integer forks;
    private Integer forksCount;
    private Integer watchers;
    private Integer watchersCount;
    private Integer openIssues;
    private Integer openIssuesCount;
    private String masterBranch;
    private String defaultBranch;
    private Boolean hasIssues;
    private Boolean hasWiki;
    private Boolean hasDownloads;
    @Mandatory
    private GithubUser owner;
    private GithubUser organization;
    private Date pushedAt;
    private Date createdAt;
    private Date updatedAt;

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getDescription() {
        return StringUtil.notNullize((String)this.description);
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isFork() {
        return this.isFork;
    }

    @NotNull
    public String getHtmlUrl() {
        return this.htmlUrl;
    }

    @NotNull
    public String getCloneUrl() {
        return this.cloneUrl;
    }

    @Nullable
    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    @NotNull
    public GithubUser getOwner() {
        return this.owner;
    }

    @NotNull
    public String getUserName() {
        return this.getOwner().getLogin();
    }

    @NotNull
    public String getFullName() {
        return this.getUserName() + "/" + this.getName();
    }

    @NotNull
    public GithubFullPath getFullPath() {
        return new GithubFullPath(this.getUserName(), this.getName());
    }
}

