/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import java.util.Collections;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GithubCreatePullRequestWorker;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.ui.GithubCreatePullRequestPanel;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubProjectSettings;
import org.jetbrains.plugins.github.util.GithubSettings;

public class GithubCreatePullRequestDialog
extends DialogWrapper {
    @NotNull
    private final GithubCreatePullRequestPanel myPanel;
    @NotNull
    private final GithubCreatePullRequestWorker myWorker;
    @NotNull
    private final GithubProjectSettings myProjectSettings;
    @NotNull
    private static final CreateRemoteDoNotAskOption ourDoNotAskOption = new CreateRemoteDoNotAskOption();

    public GithubCreatePullRequestDialog(@NotNull Project project, @NotNull GithubCreatePullRequestWorker worker) {
        super(project, true);
        this.myWorker = worker;
        this.myProjectSettings = GithubProjectSettings.getInstance(project);
        this.myPanel = new GithubCreatePullRequestPanel();
        this.myPanel.getShowDiffButton().addActionListener(e -> this.myWorker.showDiffDialog(this.myPanel.getSelectedBranch()));
        this.myPanel.getSelectForkButton().addActionListener(e -> {
            GithubCreatePullRequestWorker.ForkInfo fork = this.myWorker.showTargetDialog();
            if (fork != null) {
                this.myPanel.setForks(this.myWorker.getForks());
                this.myPanel.setSelectedFork(fork.getPath());
            }
        });
        this.myPanel.getForkComboBox().addItemListener(e -> {
            if (e.getStateChange() == 2) {
                this.myPanel.setBranches(Collections.emptyList());
            }
            if (e.getStateChange() == 1) {
                GithubCreatePullRequestWorker.ForkInfo fork = (GithubCreatePullRequestWorker.ForkInfo)e.getItem();
                if (fork == null) {
                    return;
                }
                this.myPanel.setBranches(fork.getBranches());
                this.myPanel.setSelectedBranch(fork.getDefaultBranch());
                if (fork.getRemoteName() == null && !fork.isProposedToCreateRemote()) {
                    fork.setProposedToCreateRemote(true);
                    boolean createRemote = false;
                    switch (GithubSettings.getInstance().getCreatePullRequestCreateRemote()) {
                        case YES: {
                            createRemote = true;
                            break;
                        }
                        case NO: {
                            createRemote = false;
                            break;
                        }
                        case UNSURE: {
                            createRemote = GithubNotifications.showYesNoDialog(project, "Can't Find Remote", "Configure remote for '" + fork.getPath().getUser() + "'?", ourDoNotAskOption);
                        }
                    }
                    if (createRemote) {
                        this.myWorker.configureRemote(fork);
                    }
                }
                if (fork.getRemoteName() == null) {
                    this.myPanel.setDiffEnabled(false);
                } else {
                    this.myPanel.setDiffEnabled(true);
                    this.myWorker.launchFetchRemote(fork);
                }
            }
        });
        this.myPanel.getBranchComboBox().addItemListener(e -> {
            if (e.getStateChange() == 1) {
                GithubCreatePullRequestWorker.BranchInfo branch = (GithubCreatePullRequestWorker.BranchInfo)e.getItem();
                if (branch == null) {
                    return;
                }
                if (branch.getForkInfo().getRemoteName() != null) {
                    if (branch.getDiffInfoTask() != null && branch.getDiffInfoTask().isDone() && branch.getDiffInfoTask().safeGet() == null) {
                        this.myPanel.setDiffEnabled(false);
                    } else {
                        this.myPanel.setDiffEnabled(true);
                    }
                }
                if (this.myPanel.isTitleDescriptionEmptyOrNotModified()) {
                    Couple<String> description = this.myWorker.getDefaultDescriptionMessage(branch);
                    this.myPanel.setTitle((String)description.getFirst());
                    this.myPanel.setDescription((String)description.getSecond());
                }
                this.myWorker.launchLoadDiffInfo(branch);
            }
        });
        this.myPanel.setForks(this.myWorker.getForks());
        GithubFullPath defaultRepo = this.myProjectSettings.getCreatePullRequestDefaultRepo();
        String defaultBranch = this.myProjectSettings.getCreatePullRequestDefaultBranch();
        this.myPanel.setSelectedFork(defaultRepo);
        if (defaultBranch != null) {
            this.myPanel.setSelectedBranch(defaultBranch);
        }
        this.setTitle("Create Pull Request - " + this.myWorker.getCurrentBranch());
        this.init();
    }

    protected void doOKAction() {
        GithubCreatePullRequestWorker.BranchInfo branch = this.myPanel.getSelectedBranch();
        if (this.myWorker.checkAction(branch)) {
            assert (branch != null);
            this.myWorker.createPullRequest(branch, this.getRequestTitle(), this.getDescription());
            this.myProjectSettings.setCreatePullRequestDefaultBranch(branch.getRemoteName());
            this.myProjectSettings.setCreatePullRequestDefaultRepo(branch.getForkInfo().getPath());
            super.doOKAction();
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel.getPanel();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getPreferredComponent();
    }

    protected String getHelpId() {
        return "github.create.pull.request.dialog";
    }

    protected String getDimensionServiceKey() {
        return "Github.CreatePullRequestDialog";
    }

    @NotNull
    private String getRequestTitle() {
        return this.myPanel.getTitle();
    }

    @NotNull
    private String getDescription() {
        return this.myPanel.getDescription();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (StringUtil.isEmptyOrSpaces((String)this.getRequestTitle())) {
            return new ValidationInfo("Title can't be empty'", this.myPanel.getTitleTextField());
        }
        return null;
    }

    public void testSetRequestTitle(String title) {
        this.myPanel.setTitle(title);
    }

    public void testSetBranch(String branch) {
        this.myPanel.setSelectedBranch(branch);
    }

    public void testCreatePullRequest() {
        this.myWorker.createPullRequest(this.myPanel.getSelectedBranch(), this.getRequestTitle(), this.getDescription());
    }

    public void testSetFork(@NotNull GithubFullPath forkPath) {
        this.myPanel.setSelectedFork(forkPath);
    }

    private static class CreateRemoteDoNotAskOption
    implements DialogWrapper.DoNotAskOption {
        private CreateRemoteDoNotAskOption() {
        }

        public boolean isToBeShown() {
            return true;
        }

        public void setToBeShown(boolean value, int exitCode) {
            if (value) {
                GithubSettings.getInstance().setCreatePullRequestCreateRemote(ThreeState.UNSURE);
            } else if (exitCode == 0) {
                GithubSettings.getInstance().setCreatePullRequestCreateRemote(ThreeState.YES);
            } else {
                GithubSettings.getInstance().setCreatePullRequestCreateRemote(ThreeState.NO);
            }
        }

        public boolean canBeHidden() {
            return true;
        }

        public boolean shouldSaveOptionsOnCancel() {
            return false;
        }

        @NotNull
        public String getDoNotShowMessage() {
            return CommonBundle.message((String)"dialog.options.do.not.ask", (Object[])new Object[0]);
        }
    }
}

