/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import gnu.trove.Equality;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.ui.GithubCredentialsPanel;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubSettings;

public class GithubSettingsPanel {
    private final GithubSettings mySettings;
    private JPanel myPane;
    private JSpinner myTimeoutSpinner;
    private JBCheckBox myCloneUsingSshCheckBox;
    private GithubCredentialsPanel myCredentialsPanel;

    public GithubSettingsPanel() {
        this.$$$setupUI$$$();
        this.mySettings = GithubSettings.getInstance();
        this.reset();
    }

    public JComponent getPanel() {
        return this.myPane;
    }

    @NotNull
    public GithubAuthData getAuthData() {
        GithubAuthData authData = this.myCredentialsPanel.getAuthData();
        if (authData.getBasicAuth() != null && StringUtil.isEmptyOrSpaces((String)authData.getBasicAuth().getLogin()) || authData.getTokenAuth() != null && StringUtil.isEmptyOrSpaces((String)authData.getTokenAuth().getToken())) {
            return GithubAuthData.createAnonymous(this.myCredentialsPanel.getHost());
        }
        return authData;
    }

    public void setConnectionTimeout(int timeout) {
        this.myTimeoutSpinner.setValue(timeout);
    }

    public int getConnectionTimeout() {
        return ((SpinnerNumberModel)this.myTimeoutSpinner.getModel()).getNumber().intValue();
    }

    public void reset() {
        this.myCredentialsPanel.setAuthData(this.mySettings.getAuthData());
        this.setConnectionTimeout(this.mySettings.getConnectionTimeout());
        this.myCloneUsingSshCheckBox.setSelected(this.mySettings.isCloneGitUsingSsh());
    }

    public void apply() {
        if (!GithubSettingsPanel.equal(this.mySettings.getAuthData(), this.getAuthData())) {
            this.mySettings.setAuthData(this.getAuthData(), true);
        }
        this.mySettings.setConnectionTimeout(this.getConnectionTimeout());
        this.mySettings.setCloneGitUsingSsh(this.myCloneUsingSshCheckBox.isSelected());
    }

    public boolean isModified() {
        return !GithubSettingsPanel.equal(this.mySettings.getAuthData(), this.getAuthData()) || !Comparing.equal((Object)this.mySettings.getConnectionTimeout(), (Object)this.getConnectionTimeout()) || !Comparing.equal((Object)this.mySettings.isCloneGitUsingSsh(), (Object)this.myCloneUsingSshCheckBox.isSelected());
    }

    private void createUIComponents() {
        this.myCredentialsPanel = new GithubCredentialsPanel(ProjectManager.getInstance().getDefaultProject());
        this.myTimeoutSpinner = new JSpinner(new SpinnerNumberModel(5000, 0, 60000, 500));
    }

    private static boolean equal(@NotNull GithubAuthData data1, @NotNull GithubAuthData data2) {
        return Comparing.equal((String)data1.getHost(), (String)data2.getHost()) && Comparing.equal((Object)((Object)data1.getAuthType()), (Object)((Object)data2.getAuthType())) && GithubSettingsPanel.equal(data1.getBasicAuth(), data2.getBasicAuth(), (auth1, auth2) -> Comparing.equal((String)auth1.getLogin(), (String)auth2.getLogin()) && Comparing.equal((String)auth1.getPassword(), (String)auth2.getPassword())) && GithubSettingsPanel.equal(data1.getTokenAuth(), data2.getTokenAuth(), (auth1, auth2) -> Comparing.equal((String)auth1.getToken(), (String)auth2.getToken()));
    }

    private static <T> boolean equal(@Nullable T o1, @Nullable T o2, @NotNull Equality<T> notNullEquality) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        if (o2 == null) {
            return false;
        }
        return notNullEquality.equals(o1, o2);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("html.disable", Boolean.FALSE);
        GithubCredentialsPanel githubCredentialsPanel = this.myCredentialsPanel;
        JComponent jComponent = githubCredentialsPanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        jPanel.add((Component)titledSeparator, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myCloneUsingSshCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Clone git repositories using ssh");
        jPanel.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("html.disable", Boolean.FALSE);
        jPanel.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Connection timeout:");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JSpinner jSpinner = this.myTimeoutSpinner;
        jPanel2.add((Component)jSpinner, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("ms");
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel.setLabelFor(jSpinner);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPane;
    }
}

