/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.Convertor;
import git4idea.DialogManager;
import git4idea.GitUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVersion;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubConnection;
import org.jetbrains.plugins.github.api.data.GithubUserDetailed;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubOperationCanceledException;
import org.jetbrains.plugins.github.exceptions.GithubTwoFactorAuthenticationException;
import org.jetbrains.plugins.github.ui.GithubLoginDialog;
import org.jetbrains.plugins.github.util.AuthLevel;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubAuthDataHolder;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubSettings;
import org.jetbrains.plugins.github.util.GithubUrlUtil;

public class GithubUtil {
    public static final Logger LOG = Logger.getInstance((String)"github");

    public static <T> T runTask(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator, @NotNull ThrowableConvertor<GithubConnection, T, IOException> task) throws IOException {
        return GithubUtil.runTask(project, authHolder, indicator, AuthLevel.LOGGED, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T runTask(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator, @NotNull AuthLevel authLevel, @NotNull ThrowableConvertor<GithubConnection, T, IOException> task) throws IOException {
        GithubAuthData auth = authHolder.getAuthData();
        try {
            if (!authLevel.accepts(auth)) {
                throw new GithubAuthenticationException("Expected other authentication type: " + authLevel);
            }
            GithubConnection connection = new GithubConnection(auth, true);
            ScheduledFuture<?> future = null;
            try {
                future = GithubUtil.addCancellationListener(indicator, connection);
                Object object = task.convert((Object)connection);
                return (T)object;
            }
            finally {
                connection.close();
                if (future != null) {
                    future.cancel(true);
                }
            }
        }
        catch (GithubTwoFactorAuthenticationException e) {
            GithubUtil.getTwoFactorAuthData(project, authHolder, indicator, auth);
            return GithubUtil.runTask(project, authHolder, indicator, authLevel, task);
        }
        catch (GithubAuthenticationException e) {
            GithubUtil.getValidAuthData(project, authHolder, indicator, authLevel, auth);
            return GithubUtil.runTask(project, authHolder, indicator, authLevel, task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static GithubUserDetailed testConnection(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator) throws IOException {
        GithubUserDetailed githubUserDetailed;
        GithubAuthData auth = authHolder.getAuthData();
        GithubConnection connection = new GithubConnection(auth, true);
        ScheduledFuture<?> future = null;
        try {
            future = GithubUtil.addCancellationListener(indicator, connection);
            githubUserDetailed = GithubApiUtil.getCurrentUser(connection);
        }
        catch (Throwable throwable) {
            try {
                connection.close();
                if (future != null) {
                    future.cancel(true);
                }
                throw throwable;
            }
            catch (GithubTwoFactorAuthenticationException e) {
                GithubUtil.getTwoFactorAuthData(project, authHolder, indicator, auth);
                return GithubUtil.testConnection(project, authHolder, indicator);
            }
        }
        connection.close();
        if (future != null) {
            future.cancel(true);
        }
        return githubUserDetailed;
    }

    @NotNull
    private static ScheduledFuture<?> addCancellationListener(@NotNull Runnable run) {
        return JobScheduler.getScheduler().scheduleWithFixedDelay(run, 1000L, 300L, TimeUnit.MILLISECONDS);
    }

    @NotNull
    private static ScheduledFuture<?> addCancellationListener(@NotNull ProgressIndicator indicator, @NotNull GithubConnection connection) {
        return GithubUtil.addCancellationListener(() -> {
            if (indicator.isCanceled()) {
                connection.abort();
            }
        });
    }

    @NotNull
    private static ScheduledFuture<?> addCancellationListener(@NotNull ProgressIndicator indicator, @NotNull Thread thread) {
        return GithubUtil.addCancellationListener(() -> {
            if (indicator.isCanceled()) {
                thread.interrupt();
            }
        });
    }

    private static void getValidAuthData(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator, @NotNull AuthLevel authLevel, @NotNull GithubAuthData oldAuth) throws GithubOperationCanceledException {
        authHolder.runTransaction(oldAuth, () -> {
            GithubAuthData[] authData = new GithubAuthData[1];
            ApplicationManager.getApplication().invokeAndWait(() -> {
                GithubLoginDialog dialog = new GithubLoginDialog(project, oldAuth, authLevel);
                DialogManager.show((DialogWrapper)dialog);
                if (dialog.isOK()) {
                    authData[0] = dialog.getAuthData();
                    if (!authLevel.isOnetime()) {
                        GithubSettings.getInstance().setAuthData(authData[0], dialog.isSavePasswordSelected());
                    }
                }
            }, indicator.getModalityState());
            if (authData[0] == null) {
                throw new GithubOperationCanceledException("Can't get valid credentials");
            }
            return authData[0];
        });
    }

    private static void getTwoFactorAuthData(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator, @NotNull GithubAuthData oldAuth) throws GithubOperationCanceledException {
        authHolder.runTransaction(oldAuth, () -> {
            if (authHolder.getAuthData().getAuthType() != GithubAuthData.AuthType.BASIC) {
                throw new GithubOperationCanceledException("Two factor authentication can be used only with Login/Password");
            }
            GithubApiUtil.askForTwoFactorCodeSMS(new GithubConnection(oldAuth, false));
            Ref codeRef = new Ref();
            ApplicationManager.getApplication().invokeAndWait(() -> codeRef.set((Object)Messages.showInputDialog((Project)project, (String)"Authentication Code", (String)"Github Two-Factor Authentication", null)), indicator.getModalityState());
            if (codeRef.isNull()) {
                throw new GithubOperationCanceledException("Can't get two factor authentication code");
            }
            GithubSettings settings = GithubSettings.getInstance();
            if (settings.getAuthType() == GithubAuthData.AuthType.BASIC && StringUtil.equalsIgnoreCase((CharSequence)settings.getLogin(), (CharSequence)oldAuth.getBasicAuth().getLogin())) {
                settings.setValidGitAuth(false);
            }
            return oldAuth.copyWithTwoFactorCode((String)codeRef.get());
        });
    }

    @NotNull
    public static GithubAuthDataHolder getValidAuthDataHolderFromConfig(@NotNull Project project, @NotNull AuthLevel authLevel, @NotNull ProgressIndicator indicator) throws IOException {
        GithubAuthData auth = GithubAuthData.createFromSettings();
        GithubAuthDataHolder authHolder = new GithubAuthDataHolder(auth);
        try {
            if (!authLevel.accepts(auth)) {
                throw new GithubAuthenticationException("Expected other authentication type: " + authLevel);
            }
            GithubUtil.checkAuthData(project, authHolder, indicator);
            return authHolder;
        }
        catch (GithubAuthenticationException e) {
            GithubUtil.getValidAuthData(project, authHolder, indicator, authLevel, auth);
            return authHolder;
        }
    }

    @NotNull
    public static GithubUserDetailed checkAuthData(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator) throws IOException {
        GithubAuthData auth = authHolder.getAuthData();
        if (StringUtil.isEmptyOrSpaces((String)auth.getHost())) {
            throw new GithubAuthenticationException("Target host not defined");
        }
        try {
            new URI(auth.getHost());
        }
        catch (URISyntaxException e) {
            throw new GithubAuthenticationException("Invalid host URL");
        }
        switch (auth.getAuthType()) {
            case BASIC: {
                GithubAuthData.BasicAuth basicAuth = auth.getBasicAuth();
                assert (basicAuth != null);
                if (!StringUtil.isEmptyOrSpaces((String)basicAuth.getLogin()) && !StringUtil.isEmptyOrSpaces((String)basicAuth.getPassword())) break;
                throw new GithubAuthenticationException("Empty login or password");
            }
            case TOKEN: {
                GithubAuthData.TokenAuth tokenAuth = auth.getTokenAuth();
                assert (tokenAuth != null);
                if (!StringUtil.isEmptyOrSpaces((String)tokenAuth.getToken())) break;
                throw new GithubAuthenticationException("Empty token");
            }
            case ANONYMOUS: {
                throw new GithubAuthenticationException("Anonymous connection not allowed");
            }
        }
        return GithubUtil.testConnection(project, authHolder, indicator);
    }

    public static <T> T computeValueInModalIO(@NotNull Project project, @NotNull String caption, final @NotNull ThrowableConvertor<ProgressIndicator, T, IOException> task) throws IOException {
        return (T)ProgressManager.getInstance().run(new Task.WithResult<T, IOException>(project, caption, true){

            protected T compute(@NotNull ProgressIndicator indicator) throws IOException {
                return task.convert((Object)indicator);
            }
        });
    }

    public static <T> T computeValueInModal(@NotNull Project project, @NotNull String caption, @NotNull Convertor<ProgressIndicator, T> task) {
        return GithubUtil.computeValueInModal(project, caption, true, task);
    }

    public static <T> T computeValueInModal(@NotNull Project project, @NotNull String caption, boolean canBeCancelled, final @NotNull Convertor<ProgressIndicator, T> task) {
        return (T)ProgressManager.getInstance().run(new Task.WithResult<T, RuntimeException>(project, caption, canBeCancelled){

            protected T compute(@NotNull ProgressIndicator indicator) {
                return task.convert((Object)indicator);
            }
        });
    }

    public static void computeValueInModal(@NotNull Project project, @NotNull String caption, boolean canBeCancelled, final @NotNull Consumer<ProgressIndicator> task) {
        ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<Void, RuntimeException>(project, caption, canBeCancelled){

            protected Void compute(@NotNull ProgressIndicator indicator) {
                task.consume((Object)indicator);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runInterruptable(@NotNull ProgressIndicator indicator, @NotNull ThrowableComputable<T, IOException> task) throws IOException {
        ScheduledFuture<?> future = null;
        try {
            Thread thread = Thread.currentThread();
            future = GithubUtil.addCancellationListener(indicator, thread);
            Object object = task.compute();
            return (T)object;
        }
        finally {
            if (future != null) {
                future.cancel(true);
            }
            Thread.interrupted();
        }
    }

    @Nullable
    public static String findGithubRemoteUrl(@NotNull GitRepository repository) {
        Pair<GitRemote, String> remote = GithubUtil.findGithubRemote(repository);
        if (remote == null) {
            return null;
        }
        return (String)remote.getSecond();
    }

    @Nullable
    public static Pair<GitRemote, String> findGithubRemote(@NotNull GitRepository repository) {
        Pair githubRemote = null;
        block0: for (GitRemote gitRemote : repository.getRemotes()) {
            for (String remoteUrl : gitRemote.getUrls()) {
                if (!GithubUrlUtil.isGithubUrl(remoteUrl)) continue;
                String remoteName = gitRemote.getName();
                if ("github".equals(remoteName) || "origin".equals(remoteName)) {
                    return Pair.create((Object)gitRemote, (Object)remoteUrl);
                }
                if (githubRemote != null) continue block0;
                githubRemote = Pair.create((Object)gitRemote, (Object)remoteUrl);
                continue block0;
            }
        }
        return githubRemote;
    }

    @Nullable
    public static String findUpstreamRemote(@NotNull GitRepository repository) {
        for (GitRemote gitRemote : repository.getRemotes()) {
            String remoteName = gitRemote.getName();
            if (!"upstream".equals(remoteName)) continue;
            for (String remoteUrl : gitRemote.getUrls()) {
                if (!GithubUrlUtil.isGithubUrl(remoteUrl)) continue;
                return remoteUrl;
            }
            return gitRemote.getFirstUrl();
        }
        return null;
    }

    public static boolean testGitExecutable(Project project) {
        GitVersion version;
        GitVcsApplicationSettings settings = GitVcsApplicationSettings.getInstance();
        String executable = settings.getPathToGit();
        try {
            version = GitVersion.identifyVersion((String)executable);
        }
        catch (Exception e) {
            GithubNotifications.showErrorDialog(project, GitBundle.getString((String)"find.git.error.title"), e);
            return false;
        }
        if (!version.isSupported()) {
            GithubNotifications.showWarningDialog(project, GitBundle.message((String)"find.git.unsupported.message", (Object[])new Object[]{version.toString(), GitVersion.MIN}), GitBundle.getString((String)"find.git.success.title"));
            return false;
        }
        return true;
    }

    public static boolean isRepositoryOnGitHub(@NotNull GitRepository repository) {
        return GithubUtil.findGithubRemoteUrl(repository) != null;
    }

    @NotNull
    public static String getErrorTextFromException(@NotNull Exception e) {
        if (e instanceof UnknownHostException) {
            return "Unknown host: " + e.getMessage();
        }
        return StringUtil.notNullize((String)e.getMessage(), (String)"Unknown error");
    }

    @Nullable
    public static GitRepository getGitRepository(@NotNull Project project, @Nullable VirtualFile file) {
        GitRepository repository;
        GitRepositoryManager manager = GitUtil.getRepositoryManager((Project)project);
        List repositories = manager.getRepositories();
        if (repositories.size() == 0) {
            return null;
        }
        if (repositories.size() == 1) {
            return (GitRepository)repositories.get(0);
        }
        if (file != null && (repository = (GitRepository)manager.getRepositoryForFileQuick(file)) != null) {
            return repository;
        }
        return (GitRepository)manager.getRepositoryForFileQuick(project.getBaseDir());
    }

    public static boolean addGithubRemote(@NotNull Project project, @NotNull GitRepository repository, @NotNull String remote, @NotNull String url) {
        GitSimpleHandler handler = new GitSimpleHandler(project, repository.getRoot(), GitCommand.REMOTE);
        handler.setSilent(true);
        try {
            handler.addParameters(new String[]{"add", remote, url});
            handler.run();
            if (handler.getExitCode() != 0) {
                GithubNotifications.showError(project, "Can't add remote", "Failed to add GitHub remote: '" + url + "'. " + handler.getStderr());
                return false;
            }
            repository.update();
            return true;
        }
        catch (VcsException e) {
            GithubNotifications.showError(project, "Can't add remote", (Exception)((Object)e));
            return false;
        }
    }

    public static Couple<String> getGithubLikeFormattedDescriptionMessage(String commitMessage) {
        String description;
        String subject;
        String message;
        String string = message = commitMessage == null ? "" : commitMessage.trim();
        if (message.isEmpty()) {
            return Couple.of((Object)"", (Object)"");
        }
        int firstLineEnd = message.indexOf("\n");
        if (firstLineEnd > -1) {
            subject = message.substring(0, firstLineEnd).trim();
            description = message.substring(firstLineEnd + 1).trim();
        } else {
            subject = message;
            description = "";
        }
        return Couple.of((Object)subject, (Object)description);
    }
}

