/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.git4idea.http;

import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import org.apache.xmlrpc.DefaultXmlRpcTransportFactory;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcTransportFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.git4idea.http.GitAskPassXmlRpcHandler;

class GitAskPassXmlRpcClient {
    @NotNull
    private final XmlRpcClient myClient;

    GitAskPassXmlRpcClient(int port, String token) throws IOException {
        URL url = new URL("http", "localhost", port, "/RPC2");
        DefaultXmlRpcTransportFactory factory = new DefaultXmlRpcTransportFactory(url);
        factory.setBasicAuthentication("_token_", token);
        this.myClient = new XmlRpcClient(url, (XmlRpcTransportFactory)factory);
    }

    String askUsername(String token, @NotNull String url) {
        Vector<String> parameters = new Vector<String>();
        parameters.add(token);
        parameters.add(url);
        try {
            return (String)this.myClient.execute(GitAskPassXmlRpcClient.methodName("askUsername"), parameters);
        }
        catch (IOException | XmlRpcException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
    }

    String askPassword(String token, @NotNull String url) {
        Vector<String> parameters = new Vector<String>();
        parameters.add(token);
        parameters.add(url);
        try {
            return (String)this.myClient.execute(GitAskPassXmlRpcClient.methodName("askPassword"), parameters);
        }
        catch (IOException | XmlRpcException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
    }

    @NotNull
    private static String methodName(@NotNull String method) {
        return GitAskPassXmlRpcHandler.HANDLER_NAME + "." + method;
    }
}

