/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff;

public class ReadMemoryAccess {
    byte[] bytes;
    int memOffset;
    byte[] val = new byte[8];
    boolean isle;

    public ReadMemoryAccess(byte[] octets, boolean le) {
        this.bytes = octets;
        this.memOffset = 0;
        this.isle = le;
    }

    public void getBytes(byte[] octets) {
        this.getBytes(octets, this.memOffset);
        this.memOffset += octets.length;
    }

    public void getBytes(byte[] octets, int offset) {
        this.getBytes(octets, offset, octets.length);
    }

    public void getBytes(byte[] octets, int offset, int length) {
        System.arraycopy(this.bytes, offset, octets, 0, length);
    }

    public byte getByte(int offset) {
        return this.bytes[offset];
    }

    public int getUnsignedShort() {
        if (this.isle) {
            return this.getUnsignedShortLE();
        }
        return this.getUnsignedShortBE();
    }

    public int getUnsignedShortLE() {
        int i = this.getUnsignedShortLE(this.memOffset);
        this.memOffset += 2;
        return i;
    }

    public int getUnsignedShortLE(int offset) {
        this.val[0] = this.getByte(offset);
        this.val[1] = this.getByte(offset + 1);
        return ReadMemoryAccess.getUnsignedShortLE(this.val);
    }

    public static int getUnsignedShortLE(byte[] b) {
        return (b[1] & 0xFF) << 8 | b[0] & 0xFF;
    }

    public int getUnsignedShortBE() {
        int i = this.getUnsignedShortBE(this.memOffset);
        this.memOffset += 2;
        return i;
    }

    public int getUnsignedShortBE(int offset) {
        this.val[0] = this.getByte(offset);
        this.val[1] = this.getByte(offset + 1);
        return ReadMemoryAccess.getUnsignedShortBE(this.val);
    }

    public static int getUnsignedShortBE(byte[] b) {
        return ((b[0] & 0xFF) << 8) + (b[1] & 0xFF);
    }

    public int getInt() {
        if (this.isle) {
            return this.getIntLE();
        }
        return this.getIntBE();
    }

    public int getIntLE() {
        int i = this.getIntLE(this.memOffset);
        this.memOffset += 4;
        return i;
    }

    public int getIntLE(int offset) {
        this.val[0] = this.getByte(offset);
        this.val[1] = this.getByte(offset + 1);
        this.val[2] = this.getByte(offset + 2);
        this.val[3] = this.getByte(offset + 3);
        return ReadMemoryAccess.getIntLE(this.val);
    }

    public static int getIntLE(byte[] b) {
        return (b[3] & 0xFF) << 24 | (b[2] & 0xFF) << 16 | (b[1] & 0xFF) << 8 | b[0] & 0xFF;
    }

    public int getIntBE() {
        int i = this.getIntBE(this.memOffset);
        this.memOffset += 4;
        return i;
    }

    public int getIntBE(int offset) {
        this.val[0] = this.getByte(offset);
        this.val[1] = this.getByte(offset + 1);
        this.val[2] = this.getByte(offset + 2);
        this.val[3] = this.getByte(offset + 3);
        return ReadMemoryAccess.getIntBE(this.val);
    }

    public static int getIntBE(byte[] b) {
        return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
    }
}

