/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.elf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.cdt.utils.ERandomAccessFile;

public class Elf {
    protected ERandomAccessFile efile;
    protected ELFhdr ehdr;
    protected Section[] sections;
    protected String file;
    protected byte[] section_strtab;
    private int syms = 0;
    private boolean sections_mapped;
    protected String EMPTY_STRING = "";

    private void commonSetup(String file, long offset) throws IOException {
        try {
            this.efile = new ERandomAccessFile(file, "r");
            this.efile.setFileOffset(offset);
            this.ehdr = new ELFhdr();
            this.file = file;
        }
        finally {
            if (this.ehdr == null) {
                this.dispose();
            }
        }
    }

    protected Elf() {
    }

    public Elf(String file) throws IOException {
        this.commonSetup(file, 0L);
    }

    public ELFhdr getELFhdr() throws IOException {
        return this.ehdr;
    }

    public void dispose() {
        try {
            if (this.efile != null) {
                this.efile.close();
                this.efile = null;
                if (this.sections_mapped) {
                    System.gc();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Section getSectionByName(String name) throws IOException {
        if (this.sections == null) {
            this.getSections();
        }
        int i = 0;
        while (i < this.sections.length) {
            if (this.sections[i].toString().equals(name)) {
                return this.sections[i];
            }
            ++i;
        }
        return null;
    }

    public Section[] getSections() throws IOException {
        if (this.sections == null) {
            if (this.ehdr.e_shoff == 0L) {
                this.sections = new Section[0];
                return this.sections;
            }
            int length = this.ehdr.e_shnum & 0xFFFF;
            this.sections = new Section[length];
            int i = 0;
            while (i < length) {
                this.efile.seek(this.ehdr.e_shoff + (long)(i * (this.ehdr.e_shentsize & 0xFFFF)));
                this.sections[i] = new Section();
                this.sections[i].sh_name = this.efile.readIntE();
                this.sections[i].sh_type = this.efile.readIntE();
                switch (this.ehdr.e_ident[4]) {
                    case 1: {
                        byte[] addrArray = new byte[4];
                        this.sections[i].sh_flags = this.efile.readIntE();
                        this.efile.readFullyE(addrArray);
                        this.sections[i].sh_addr = new Addr32(addrArray);
                        this.sections[i].sh_offset = this.efile.readIntE();
                        this.sections[i].sh_size = this.efile.readIntE();
                        break;
                    }
                    case 2: {
                        byte[] addrArray = new byte[8];
                        this.sections[i].sh_flags = this.efile.readLongE();
                        this.efile.readFullyE(addrArray);
                        this.sections[i].sh_addr = new Addr64(addrArray);
                        this.sections[i].sh_offset = this.readUnsignedLong(this.efile);
                        this.sections[i].sh_size = this.readUnsignedLong(this.efile);
                        break;
                    }
                    default: {
                        throw new IOException("Unknown ELF class " + this.ehdr.e_ident[4]);
                    }
                }
                this.sections[i].sh_link = this.efile.readIntE();
                this.sections[i].sh_info = this.efile.readIntE();
                switch (this.ehdr.e_ident[4]) {
                    case 1: {
                        this.sections[i].sh_addralign = this.efile.readIntE();
                        this.sections[i].sh_entsize = this.efile.readIntE();
                        break;
                    }
                    case 2: {
                        this.sections[i].sh_addralign = this.efile.readLongE();
                        this.sections[i].sh_entsize = this.readUnsignedLong(this.efile);
                        break;
                    }
                    default: {
                        throw new IOException("Unknown ELF class " + this.ehdr.e_ident[4]);
                    }
                }
                if (this.sections[i].sh_type == 2L) {
                    this.syms = i;
                }
                if (this.syms == 0 && this.sections[i].sh_type == 11L) {
                    this.syms = i;
                }
                ++i;
            }
        }
        return this.sections;
    }

    public String getFilename() {
        return this.file;
    }

    protected long readUnsignedLong(ERandomAccessFile file) throws IOException {
        long result = file.readLongE();
        if (result < 0L) {
            throw new IOException("Maximal file offset is " + Long.toHexString(Long.MAX_VALUE) + " given offset is " + Long.toHexString(result));
        }
        return result;
    }

    public class ELFhdr {
        public byte[] e_ident = new byte[16];
        public int e_type;
        public int e_machine;
        public long e_version;
        public IAddress e_entry;
        public long e_phoff;
        public long e_shoff;
        public long e_flags;
        public short e_ehsize;
        public short e_phentsize;
        public short e_phnum;
        public short e_shentsize;
        public short e_shnum;
        public short e_shstrndx;

        protected ELFhdr() throws IOException {
            Elf.this.efile.seek(0L);
            Elf.this.efile.readFully(this.e_ident);
            if (this.e_ident[0] != 127 || this.e_ident[1] != 69 || this.e_ident[2] != 76 || this.e_ident[3] != 70) {
                throw new IOException(CCorePlugin.getResourceString("Util.exception.notELF"));
            }
            Elf.this.efile.setEndian(this.e_ident[5] == 1);
            this.e_type = Elf.this.efile.readShortE();
            this.e_machine = Elf.this.efile.readShortE();
            this.e_version = Elf.this.efile.readIntE();
            switch (this.e_ident[4]) {
                case 1: {
                    byte[] addrArray = new byte[4];
                    Elf.this.efile.readFullyE(addrArray);
                    this.e_entry = new Addr32(addrArray);
                    this.e_phoff = Elf.this.efile.readIntE();
                    this.e_shoff = Elf.this.efile.readIntE();
                    break;
                }
                case 2: {
                    byte[] addrArray = new byte[8];
                    Elf.this.efile.readFullyE(addrArray);
                    this.e_entry = new Addr64(addrArray);
                    this.e_phoff = Elf.this.readUnsignedLong(Elf.this.efile);
                    this.e_shoff = Elf.this.readUnsignedLong(Elf.this.efile);
                    break;
                }
                default: {
                    throw new IOException("Unknown ELF class " + this.e_ident[4]);
                }
            }
            this.e_flags = Elf.this.efile.readIntE();
            this.e_ehsize = Elf.this.efile.readShortE();
            this.e_phentsize = Elf.this.efile.readShortE();
            this.e_phnum = Elf.this.efile.readShortE();
            this.e_shentsize = Elf.this.efile.readShortE();
            this.e_shnum = Elf.this.efile.readShortE();
            this.e_shstrndx = Elf.this.efile.readShortE();
        }
    }

    public class Section {
        public long sh_name;
        public long sh_type;
        public long sh_flags;
        public IAddress sh_addr;
        public long sh_offset;
        public long sh_size;
        public long sh_link;
        public long sh_info;
        public long sh_addralign;
        public long sh_entsize;

        public ByteBuffer mapSectionData() throws IOException {
            Elf.this.sections_mapped = true;
            return Elf.this.efile.getChannel().map(FileChannel.MapMode.READ_ONLY, this.sh_offset, this.sh_size).load().asReadOnlyBuffer();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String toString() {
            try {
                if (Elf.this.section_strtab == null) {
                    int shstrndx = Elf.this.ehdr.e_shstrndx & 0xFFFF;
                    if (shstrndx > Elf.this.sections.length || shstrndx < 0) {
                        return Elf.this.EMPTY_STRING;
                    }
                    int size = (int)Elf.this.sections[shstrndx].sh_size;
                    if (size <= 0 || (long)size > Elf.this.efile.length()) {
                        return Elf.this.EMPTY_STRING;
                    }
                    Elf.this.section_strtab = new byte[size];
                    Elf.this.efile.seek(Elf.this.sections[shstrndx].sh_offset);
                    Elf.this.efile.read(Elf.this.section_strtab);
                }
                int str_size = 0;
                if (this.sh_name > (long)Elf.this.section_strtab.length) {
                    return Elf.this.EMPTY_STRING;
                }
                while (true) {
                    if (Elf.this.section_strtab[(int)this.sh_name + str_size] == 0) {
                        return new String(Elf.this.section_strtab, (int)this.sh_name, str_size);
                    }
                    ++str_size;
                }
            }
            catch (IOException e) {
                return Elf.this.EMPTY_STRING;
            }
        }
    }
}

