/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.SimpleEventRenderer;
import com.android.tools.adtui.model.event.EventAction;
import com.intellij.openapi.util.IconLoader;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class EventIconRenderer<E>
implements SimpleEventRenderer<E> {
    @NotNull
    private Icon myIcon;
    @NotNull
    private int myIconWidth;

    @NotNull
    private static Icon load(String path) {
        return IconLoader.getIcon((String)path, EventIconRenderer.class);
    }

    public EventIconRenderer(String icon) {
        this(EventIconRenderer.load(icon));
    }

    EventIconRenderer(@NotNull Icon icon) {
        this.myIcon = icon;
        this.myIconWidth = this.myIcon.getIconWidth();
    }

    @Override
    public void draw(Component parent, Graphics2D g2d, AffineTransform transform, double length, EventAction<E> notUsedData) {
        Icon icon = this.myIcon;
        AffineTransform originalTransform = g2d.getTransform();
        g2d.transform(transform);
        icon.paintIcon(parent, g2d, -this.myIconWidth / 2, 0);
        g2d.setTransform(originalTransform);
    }
}

