/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.common.AdtUiUtils;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.jetbrains.annotations.NotNull;
import sun.swing.SwingUtilities2;

public class FlatTabbedPane
extends JTabbedPane {
    @NotNull
    private final FlatTabbedPaneUI myUi = new FlatTabbedPaneUI();

    public FlatTabbedPane() {
        this.setUI(this.myUi);
        this.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        this.getActionMap().put("navigatePrevious", new NavigateAction(ActionDirection.LEFT));
        this.getActionMap().put("navigateNext", new NavigateAction(ActionDirection.RIGHT));
        this.getActionMap().put("navigateLeft", new NavigateAction(ActionDirection.LEFT));
        this.getActionMap().put("navigateRight", new NavigateAction(ActionDirection.RIGHT));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                FlatTabbedPane.this.myUi.setHoveredTabIndex(-1);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                FlatTabbedPane.this.setTabIndexForMouseEvent(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                FlatTabbedPane.this.setTabIndexForMouseEvent(e);
            }
        });
    }

    @Override
    public void updateUI() {
        this.setUI(this.myUi);
    }

    @NotNull
    public Insets getTabAreaInsets() {
        return this.myUi.myTabAreaInsets;
    }

    public void setTabAreaInsets(@NotNull Insets insets) {
        this.myUi.setTabAreaInsets(insets);
    }

    @NotNull
    public Insets getTabInsets() {
        return this.myUi.myTabInsets;
    }

    public void setTabInsets(@NotNull Insets insets) {
        this.myUi.setTabInsets(insets);
    }

    @NotNull
    public Insets getContentBorderInsets() {
        return this.myUi.myContentBorderInsets;
    }

    public void setContentBorderInsets(@NotNull Insets insets) {
        this.myUi.setContentBorderInsets(insets);
    }

    private void setTabIndexForMouseEvent(@NotNull MouseEvent e) {
        int tabIndex = this.myUi.tabForCoordinate(this, e.getX(), e.getY());
        this.myUi.setHoveredTabIndex(tabIndex);
    }

    private static class FlatTabbedPaneUI
    extends BasicTabbedPaneUI {
        private static final Color DEFAULT_ACTIVE_COLOR = new JBColor(new Color(255, 255, 255), new Color(81, 86, 88));
        private static final Color DEFAULT_INACTIVE_COLOR = new JBColor(new Color(212, 212, 212), new Color(60, 62, 63));
        private static final Color DEFAULT_HOVER_COLOR = new JBColor(new Color(230, 230, 230), new Color(70, 74, 75));
        private static final Color DEFAULT_BORDER_COLOR = new JBColor((Color)Gray._201, (Color)Gray._40);
        private static final Insets DEFAULT_TAB_INSETS = new Insets(5, 12, 5, 12);
        private static final Insets DEFAULT_TAB_AREA_INSETS = new Insets(3, 0, -1, 0);
        private static final Insets DEFAULT_CONTENT_BORDER_INSETS = new Insets(4, 0, 0, 0);
        private int myHoveredTabIndex = -1;
        @NotNull
        private final Color myActiveColor = DEFAULT_ACTIVE_COLOR;
        @NotNull
        private final Color myInactiveColor = DEFAULT_INACTIVE_COLOR;
        @NotNull
        private final Color myHoverColor = DEFAULT_HOVER_COLOR;
        @NotNull
        private final Color myBorderColor = DEFAULT_BORDER_COLOR;
        @NotNull
        private Insets myTabInsets = DEFAULT_TAB_INSETS;
        @NotNull
        private Insets myTabAreaInsets = DEFAULT_TAB_AREA_INSETS;
        @NotNull
        private Insets myContentBorderInsets = DEFAULT_CONTENT_BORDER_INSETS;

        @Override
        public void installUI(JComponent c) {
            super.installUI(c);
            this.tabInsets = this.myTabInsets;
            this.tabAreaInsets = this.myTabAreaInsets;
            this.contentBorderInsets = this.myContentBorderInsets;
        }

        private void setTabAreaInsets(@NotNull Insets insets) {
            this.myTabAreaInsets = insets;
            this.tabPane.invalidate();
            this.tabPane.repaint();
        }

        private void setTabInsets(@NotNull Insets insets) {
            this.myTabInsets = insets;
            this.tabPane.invalidate();
            this.tabPane.repaint();
        }

        private void setContentBorderInsets(@NotNull Insets insets) {
            this.myContentBorderInsets = insets;
            this.tabPane.invalidate();
            this.tabPane.repaint();
        }

        private void setHoveredTabIndex(int index) {
            Rectangle tabBound;
            int previousIndex = this.myHoveredTabIndex;
            this.myHoveredTabIndex = index;
            if (previousIndex >= 0) {
                tabBound = this.getTabBounds(this.tabPane, previousIndex);
                this.tabPane.repaint(tabBound);
            }
            if (this.myHoveredTabIndex >= 0) {
                tabBound = this.getTabBounds(this.tabPane, this.myHoveredTabIndex);
                this.tabPane.repaint(tabBound);
            }
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            if (!this.tabPane.isValid()) {
                this.tabPane.validate();
            }
            int selectedIndex = this.tabPane.getSelectedIndex();
            int tabPlacement = this.tabPane.getTabPlacement();
            this.paintTabArea(g, tabPlacement, selectedIndex);
            this.paintContentBorder(g, tabPlacement, selectedIndex);
        }

        @Override
        protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
            if (g instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR);
            }
            Rectangle tabRect = rects[tabIndex];
            String title = this.tabPane.getTitleAt(tabIndex);
            Icon icon = this.getIconForTab(tabIndex);
            int selectedIndex = this.tabPane.getSelectedIndex();
            boolean isSelected = selectedIndex == tabIndex;
            Font font = this.tabPane.getFont();
            FontMetrics metrics = SwingUtilities2.getFontMetrics(this.tabPane, g, font);
            if (isSelected) {
                g.setColor(this.myActiveColor);
            } else if (tabIndex == this.myHoveredTabIndex) {
                g.setColor(this.myHoverColor);
            } else {
                g.setColor(this.myInactiveColor);
            }
            g.fillRect(tabRect.x, tabRect.y, tabRect.width, tabRect.height);
            this.paintTabBorder(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
            if (this.tabPane.getTabComponentAt(tabIndex) == null) {
                iconRect.y = 0;
                iconRect.x = 0;
                textRect.y = 0;
                textRect.x = 0;
                SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, 0, 0, 11, tabRect, iconRect, textRect, this.textIconGap);
                this.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
                this.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
            }
        }

        @Override
        protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
            int startX = x;
            int endX = x + w;
            int startY = y;
            int endY = y + h;
            g.setColor(this.myBorderColor);
            switch (tabPlacement) {
                case 2: {
                    if (startY > 0) {
                        g.drawLine(startX, startY, endX, startY);
                    }
                    g.drawLine(startX, startY, startX, endY);
                    g.drawLine(startX, endY, endX, endY);
                    break;
                }
                case 4: {
                    if (startY > 0) {
                        g.drawLine(startX, startY, endX, startY);
                    }
                    g.drawLine(endX, startY, endX, endY);
                    g.drawLine(startX, endY, endX, endY);
                    break;
                }
                case 3: {
                    if (startX > 0) {
                        g.drawLine(startX, startY, startX, endY);
                    }
                    g.drawLine(startX + w, startY, endX, endY);
                    g.drawLine(startX, endY, endX, endY);
                    break;
                }
                default: {
                    if (startX > 0) {
                        g.drawLine(startX, startY, startX, endY);
                    }
                    g.drawLine(startX, startY, endX, startY);
                    g.drawLine(endX, startY, endX, endY);
                }
            }
        }

        @Override
        protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
            int width = this.tabPane.getWidth();
            int height = this.tabPane.getHeight();
            Insets insets = this.tabPane.getInsets();
            int x = insets.left;
            int y = insets.top;
            int w = width - insets.right - insets.left;
            int h = height - insets.top - insets.bottom;
            switch (tabPlacement) {
                case 2: {
                    w -= (x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) + 1) - insets.left;
                    break;
                }
                case 4: {
                    w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) + 1;
                    break;
                }
                case 3: {
                    h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) + 1;
                    break;
                }
                default: {
                    h -= (y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) + 1) - insets.top;
                }
            }
            if (this.tabPane.getTabCount() > 0 && this.tabPane.isOpaque()) {
                g.setColor(this.myActiveColor);
                g.fillRect(x, y, w, h);
            }
            g.setColor(this.myBorderColor);
            this.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
            this.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
            this.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
            this.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        }

        @Override
        protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
            Rectangle selRect;
            if (tabPlacement != 1) {
                return;
            }
            Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
            if (selectedIndex < 0 || selRect.y + selRect.height + 1 < y || selRect.x < x || selRect.x > x + w) {
                g.drawLine(x, y, x + w, y);
            } else {
                if (selRect.x - x > 0) {
                    g.drawLine(x, y, selRect.x, y);
                }
                if (selRect.x + selRect.width < x + w) {
                    g.drawLine(selRect.x + selRect.width, y, x + w, y);
                }
            }
        }

        @Override
        protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
            Rectangle selRect;
            if (tabPlacement != 2) {
                return;
            }
            Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
            if (selectedIndex < 0 || selRect.x + selRect.width + 1 < x || selRect.y < y || selRect.y > y + h) {
                g.drawLine(x, y, x, y + h);
            } else {
                if (selRect.y - y > 0) {
                    g.drawLine(x, y, x, selRect.y);
                }
                if (selRect.y + selRect.height < y + h) {
                    g.drawLine(x, selRect.y + selRect.height, x, y + h);
                }
            }
        }

        @Override
        protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
            Rectangle selRect;
            if (tabPlacement != 3) {
                return;
            }
            Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
            if (selectedIndex < 0 || selRect.y - 1 > h || selRect.x < x || selRect.x > x + w) {
                g.drawLine(x, y + h, x + w, y + h);
            } else {
                if (selRect.x - x > 0) {
                    g.drawLine(x, y + h, selRect.x, y + h);
                }
                if (selRect.x + selRect.width < x + w) {
                    g.drawLine(selRect.x + selRect.width, y + h, x + w, y + h);
                }
            }
        }

        @Override
        protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
            Rectangle selRect;
            if (tabPlacement != 4) {
                return;
            }
            Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
            if (selectedIndex < 0 || selRect.x - 1 > w || selRect.y < y || selRect.y > y + h) {
                g.drawLine(x + w, y, x + w, y + h);
            } else {
                if (selRect.y - y > 0) {
                    g.drawLine(x + w, y, x + w, selRect.y);
                }
                if (selRect.y + selRect.height < y + h) {
                    g.drawLine(x + w, selRect.y + selRect.height, x + w, y + h);
                }
            }
        }
    }

    final class NavigateAction
    extends AbstractAction {
        private final ActionDirection myDirection;

        NavigateAction(ActionDirection direction) {
            this.myDirection = direction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int tabCount = FlatTabbedPane.this.getTabCount();
            if (this.myDirection == ActionDirection.RIGHT) {
                FlatTabbedPane.this.setSelectedIndex((FlatTabbedPane.this.getSelectedIndex() + 1) % tabCount);
            } else {
                FlatTabbedPane.this.setSelectedIndex((FlatTabbedPane.this.getSelectedIndex() - 1 + tabCount) % tabCount);
            }
        }
    }

    static enum ActionDirection {
        LEFT,
        RIGHT;

    }
}

