/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SelectionModel;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public final class SelectionComponent
extends AnimatedComponent {
    public static final Color DEFAULT_SELECTION_COLOR = new JBColor(new Color(855931098, true), new Color(1277400565, true));
    public static final Color DEFAULT_SELECTION_BORDER = new JBColor(new Color(1275361498, true), new Color(1275361498, true));
    private static final Color DEFAULT_HANDLE = new JBColor(0x696868, 0xD6D6D6);
    public static final int HANDLE_HEIGHT = 40;
    public static final int HANDLE_WIDTH = 5;
    private static final double SELECTION_MOVE_PERCENT = 0.01;
    private int myMousePressed;
    private Mode myMode;
    @NotNull
    private final SelectionModel myModel;

    public SelectionComponent(@NotNull SelectionModel model) {
        this.myModel = model;
        this.myMode = Mode.NONE;
        this.setFocusable(true);
        this.initListeners();
        this.myModel.addDependency(this.myAspectObserver).onChange(SelectionModel.Aspect.SELECTION, this::modelChanged);
    }

    private void modelChanged() {
        this.opaqueRepaint();
    }

    private void initListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SelectionComponent.this.requestFocusInWindow();
                Dimension size = SelectionComponent.this.getSize();
                int x = e.getX();
                double startXPos = SelectionComponent.this.rangeToX(SelectionComponent.this.myModel.getSelectionRange().getMin(), size);
                double endXPos = SelectionComponent.this.rangeToX(SelectionComponent.this.myModel.getSelectionRange().getMax(), size);
                if (startXPos - 5.0 < (double)x && (double)x < startXPos) {
                    SelectionComponent.this.myMode = Mode.ADJUST_MIN;
                } else if (endXPos < (double)x && (double)x < endXPos + 5.0) {
                    SelectionComponent.this.myMode = Mode.ADJUST_MAX;
                } else if (startXPos <= (double)x && (double)x <= endXPos) {
                    SelectionComponent.this.myMode = Mode.MOVE;
                } else {
                    SelectionComponent.this.myModel.beginUpdate();
                    double value = SelectionComponent.this.xToRange(x);
                    SelectionComponent.this.myModel.set(value, value);
                    SelectionComponent.this.myMode = Mode.CREATE;
                }
                SelectionComponent.this.myMousePressed = e.getX();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SelectionComponent.this.myMode == Mode.CREATE) {
                    SelectionComponent.this.myModel.endUpdate();
                }
                SelectionComponent.this.myMode = Mode.NONE;
                SelectionComponent.this.opaqueRepaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                double pressed = SelectionComponent.this.xToRange(SelectionComponent.this.myMousePressed);
                double current = SelectionComponent.this.xToRange(e.getX());
                double rangeDelta = current - pressed;
                double min = SelectionComponent.this.myModel.getSelectionRange().getMin();
                double max = SelectionComponent.this.myModel.getSelectionRange().getMax();
                switch (SelectionComponent.this.myMode) {
                    case ADJUST_MIN: {
                        if (min + rangeDelta > max) {
                            SelectionComponent.this.myModel.set(max, min + rangeDelta);
                            SelectionComponent.this.myMode = Mode.ADJUST_MAX;
                        } else {
                            SelectionComponent.this.myModel.set(min + rangeDelta, max);
                        }
                        SelectionComponent.this.myMousePressed = e.getX();
                        break;
                    }
                    case ADJUST_MAX: {
                        if (max + rangeDelta < min) {
                            SelectionComponent.this.myModel.set(max + rangeDelta, min);
                            SelectionComponent.this.myMode = Mode.ADJUST_MIN;
                        } else {
                            SelectionComponent.this.myModel.set(min, max + rangeDelta);
                        }
                        SelectionComponent.this.myMousePressed = e.getX();
                        break;
                    }
                    case MOVE: {
                        SelectionComponent.this.myModel.set(min + rangeDelta, max + rangeDelta);
                        SelectionComponent.this.myMousePressed = e.getX();
                        break;
                    }
                    case CREATE: {
                        SelectionComponent.this.myModel.set(pressed < current ? pressed : current, pressed < current ? current : pressed);
                        break;
                    }
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 27: {
                        if (SelectionComponent.this.myModel.getSelectionRange().isEmpty()) break;
                        SelectionComponent.this.myModel.getSelectionRange().clear();
                        e.consume();
                        break;
                    }
                    case 37: {
                        SelectionComponent.this.shiftModel(ShiftDirection.LEFT, e.isAltDown(), e.isShiftDown());
                        break;
                    }
                    case 39: {
                        SelectionComponent.this.shiftModel(ShiftDirection.RIGHT, e.isShiftDown(), e.isAltDown());
                    }
                }
                SelectionComponent.this.myModel.endUpdate();
            }
        });
    }

    private void shiftModel(ShiftDirection direction, boolean zeroMin, boolean zeroMax) {
        double maxDelta;
        double min = this.myModel.getSelectionRange().getMin();
        double max = this.myModel.getSelectionRange().getMax();
        double rangeDelta = this.myModel.getRange().getLength() * 0.01;
        rangeDelta = direction == ShiftDirection.LEFT ? rangeDelta * -1.0 : rangeDelta;
        double minDelta = zeroMin ? 0.0 : rangeDelta;
        double d = maxDelta = zeroMax ? 0.0 : rangeDelta;
        if (max < min) {
            max = min = this.myModel.getRange().getLength() / 2.0 + this.myModel.getRange().getMin();
        }
        this.myModel.beginUpdate();
        this.myModel.set(min + minDelta, max + maxDelta);
        this.myModel.endUpdate();
    }

    private double xToRange(int x) {
        Range range = this.myModel.getRange();
        return (double)x / this.getSize().getWidth() * range.getLength() + range.getMin();
    }

    private float rangeToX(double value, Dimension dim) {
        Range range = this.myModel.getRange();
        return (float)(dim.getWidth() * ((value - range.getMin()) / (range.getMax() - range.getMin())));
    }

    @Override
    protected void draw(Graphics2D g, Dimension dim) {
        if (this.myModel.getSelectionRange().isEmpty()) {
            return;
        }
        float startXPos = this.rangeToX(this.myModel.getSelectionRange().getMin(), dim);
        float endXPos = this.rangeToX(this.myModel.getSelectionRange().getMax(), dim);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(DEFAULT_SELECTION_COLOR);
        Rectangle2D.Float rect = new Rectangle2D.Float(startXPos, 0.0f, endXPos - startXPos, dim.height);
        g.fill(rect);
        g.setColor(DEFAULT_SELECTION_BORDER);
        Path2D.Float path = new Path2D.Float();
        path.moveTo(startXPos, 0.0f);
        path.lineTo(startXPos, dim.height);
        path.moveTo(endXPos - 1.0f, dim.height);
        path.lineTo(endXPos - 1.0f, 0.0f);
        g.draw(path);
        if (this.myMode != Mode.CREATE) {
            this.drawHandle(g, startXPos, dim.height, 1.0f);
            this.drawHandle(g, endXPos, dim.height, -1.0f);
        }
    }

    private void drawHandle(Graphics2D g, float x, float height, float direction) {
        float up = (height - 40.0f) * 0.5f;
        float down = (height + 40.0f) * 0.5f;
        float width = 5.0f * direction;
        g.setColor(DEFAULT_HANDLE);
        Path2D.Float path = new Path2D.Float();
        path.moveTo(x, up);
        path.lineTo(x, down);
        path.quadTo(x - width, down, x - width, down - 5.0f);
        path.lineTo(x - width, up + 5.0f);
        path.quadTo(x - width, up, x, up);
        g.fill(path);
    }

    private static enum ShiftDirection {
        LEFT,
        RIGHT;

    }

    private static enum Mode {
        NONE,
        CREATE,
        MOVE,
        ADJUST_MIN,
        ADJUST_MAX;

    }
}

