/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.intellij.openapi.diagnostic.Logger;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public final class TableUtils {
    private TableUtils() {
    }

    public static void paste(@NotNull JTable table, @NotNull Transferable transferable) {
        if (table.getSelectedRowCount() != 1 || table.getSelectedColumnCount() != 1) {
            return;
        }
        if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return;
        }
        int row = table.getSelectedRow();
        int rowCount = table.getRowCount();
        int selectedColumn = table.getSelectedColumn();
        int columnCount = table.getColumnCount();
        for (String values : TableUtils.getTransferDataAsString(transferable).split("\n")) {
            if (row >= rowCount) break;
            int column = selectedColumn;
            for (String value : values.split("\t")) {
                if (column >= columnCount) break;
                table.setValueAt(value, row, column++);
            }
            ++row;
        }
    }

    @NotNull
    private static String getTransferDataAsString(@NotNull Transferable transferable) {
        try {
            return (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            Logger.getInstance(TableUtils.class).warn((Throwable)exception);
            return "";
        }
    }

    public static void selectCellAt(@NotNull JTable table, int row, int column) {
        table.setRowSelectionInterval(row, row);
        table.setColumnSelectionInterval(column, column);
    }
}

