/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public final class TooltipComponent
extends AnimatedComponent {
    private final Component myComponent;
    @Nullable
    private Point myLastPoint;

    public TooltipComponent(Component component) {
        this.myComponent = component;
        this.add(component);
    }

    public void registerListenersOn(Component component) {
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                this.handleMove(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TooltipComponent.this.myLastPoint = null;
                TooltipComponent.this.opaqueRepaint();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.handleMove(e);
            }

            private void handleMove(MouseEvent e) {
                TooltipComponent.this.myLastPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), TooltipComponent.this);
                TooltipComponent.this.opaqueRepaint();
            }
        };
        component.addMouseMotionListener(adapter);
        component.addMouseListener(adapter);
    }

    @Override
    protected void draw(Graphics2D g, Dimension dim) {
        if (this.myLastPoint == null) {
            this.myComponent.setVisible(false);
            return;
        }
        this.myComponent.setVisible(true);
        Dimension size = this.myComponent.getPreferredSize();
        Dimension minSize = this.myComponent.getMinimumSize();
        size = new Dimension(Math.max(size.width, minSize.width), Math.max(size.height, minSize.height));
        g.setColor(Color.WHITE);
        int gap = 10;
        int x1 = Math.max(Math.min(this.myLastPoint.x + gap, dim.width - size.width - gap), 0);
        int y1 = Math.max(Math.min(this.myLastPoint.y + gap, dim.height - size.height - gap), gap);
        int width = size.width;
        int height = size.height;
        g.fillRect(x1, y1, width, height);
        g.setStroke(new BasicStroke(1.0f));
        int lines = 4;
        int[] alphas = new int[]{40, 30, 20, 10};
        RoundRectangle2D.Float rect = new RoundRectangle2D.Float();
        for (int i = 0; i < lines; ++i) {
            g.setColor(new Color(0, 0, 0, alphas[i]));
            rect.setRoundRect(x1 - 1 - i, y1 - 1 - i, width + 1 + i * 2, height + 1 + i * 2, i * 2 + 2, i * 2 + 2);
            g.draw(rect);
        }
        this.myComponent.setBounds(x1, y1, width, height);
        this.myComponent.repaint();
    }
}

