/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.SimpleEventRenderer;
import com.android.tools.adtui.model.event.EventAction;
import com.intellij.ui.JBColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;

public class TouchEventRenderer<E>
implements SimpleEventRenderer<E> {
    private static final JBColor HOLD_COLOR = new JBColor(new Color(1720548302, true), new Color(1721267928, true));
    private static final JBColor TOUCH_COLOR = new JBColor(new Color(-863142962, true), new Color(-862423336, true));
    private static final int MIN_LENGTH = 20;
    private int myLineWidth = 12;

    @Override
    public void draw(Component parent, Graphics2D g2d, AffineTransform transform, double length, EventAction<E> notUsedData) {
        Color currentColor = g2d.getColor();
        Stroke currentStroke = g2d.getStroke();
        double xPosition = transform.getTranslateX() - (double)this.myLineWidth / 2.0;
        double yPosition = transform.getTranslateY() + (double)this.myLineWidth / 2.0;
        if (length >= 20.0) {
            BasicStroke str = new BasicStroke(this.myLineWidth);
            g2d.setStroke(str);
            g2d.setColor((Color)HOLD_COLOR);
            RoundRectangle2D.Double rect = new RoundRectangle2D.Double(xPosition, yPosition, length, this.myLineWidth, this.myLineWidth, this.myLineWidth);
            g2d.fill(rect);
            g2d.setStroke(currentStroke);
        }
        g2d.setColor((Color)TOUCH_COLOR);
        Ellipse2D.Double ellipse = new Ellipse2D.Double(xPosition, yPosition, this.myLineWidth, this.myLineWidth);
        g2d.fill(ellipse);
        g2d.setColor(currentColor);
    }
}

