/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.actions;

import com.android.tools.adtui.actions.DropDownActionButton;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Component;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DropDownAction
extends DefaultActionGroup
implements CustomComponentAction {
    @Nullable
    private JBPopup myCurrentPopup = null;

    public DropDownAction(@Nullable String title, @Nullable String description, @Nullable Icon icon) {
        super(title, true);
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText(title);
        presentation.setDescription(description);
        presentation.setIcon(icon != null ? icon : EmptyIcon.ICON_0);
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent eve) {
        DropDownActionButton button = DropDownAction.getActionButton(eve);
        if (button == null) {
            return;
        }
        this.updateActions();
        JPanel componentPopup = this.createCustomComponentPopup();
        if (componentPopup == null) {
            this.showPopupMenu(eve, button);
        } else {
            this.showJBPopup(eve, button, componentPopup);
        }
    }

    private void showPopupMenu(@NotNull AnActionEvent eve, @NotNull DropDownActionButton button) {
        ActionManagerImpl am = (ActionManagerImpl)ActionManager.getInstance();
        am.createActionPopupMenu(eve.getPlace(), (ActionGroup)this).getComponent().show((Component)((Object)button), 0, button.getHeight());
    }

    private void showJBPopup(@NotNull AnActionEvent eve, @NotNull DropDownActionButton button, @NotNull JPanel componentPopup) {
        JBPopup popup = this.createJBPopup(componentPopup);
        Component owner = eve.getInputEvent().getComponent();
        Point location = owner.getLocationOnScreen();
        location.translate(0, owner.getHeight());
        popup.showInScreenCoordinates(owner, location);
        button.setSelected(true);
        ((DropDownAction)button.getAction()).myCurrentPopup = popup;
    }

    private static DropDownActionButton getActionButton(@NotNull AnActionEvent eve) {
        return (DropDownActionButton)((Object)eve.getPresentation().getClientProperty("customComponent"));
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation) {
        DropDownActionButton button = new DropDownActionButton((AnAction)this, presentation, "toolbar");
        this.updateActions();
        return button;
    }

    @NotNull
    private JBPopup createJBPopup(@NotNull JPanel content) {
        JBPopupFactory popupFactory = JBPopupFactory.getInstance();
        JBPopup popupMenu = popupFactory.createComponentPopupBuilder((JComponent)content, (JComponent)content).createPopup();
        popupMenu.addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                super.onClosed(event);
                DropDownActionButton button = (DropDownActionButton)((Object)event.asPopup().getOwner());
                button.setSelected(false);
                button.revalidate();
                button.repaint();
                event.asPopup().removeListener((JBPopupListener)this);
                ((DropDownAction)button.getAction()).myCurrentPopup = null;
            }
        });
        return popupMenu;
    }

    @Nullable
    protected JPanel createCustomComponentPopup() {
        return null;
    }

    protected boolean updateActions() {
        return false;
    }

    public boolean canBePerformed(@Nullable DataContext context) {
        return true;
    }

    public void closePopup() {
        if (this.myCurrentPopup != null) {
            this.myCurrentPopup.closeOk(null);
            this.myCurrentPopup = null;
        }
    }
}

