/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.ui.TextAccessor;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;

public class DropDownActionButton
extends ActionButtonWithText
implements TextAccessor {
    private static final int DROP_DOWN_ICON_MARGIN_RIGHT = JBUI.scale((int)2);
    private static final Icon DROP_DOWN_ICON = AllIcons.General.Combo3;
    private static final int ICON_TEXT_SPACE = JBUI.scale((int)4);
    private static final Border ICON_MARGIN_BORDER = BorderFactory.createEmptyBorder(0, 0, 0, DROP_DOWN_ICON.getIconWidth());
    private boolean myIsSelected = false;

    public DropDownActionButton(@NotNull AnAction action, @NotNull Presentation presentation, @NotNull String place) {
        super(action, presentation, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        this.setHorizontalTextAlignment(0);
        this.setBorder(new CompoundBorder(this.getBorder(), ICON_MARGIN_BORDER));
    }

    public int getPopState() {
        return this.myIsSelected ? 1 : super.getPopState();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Insets insets = this.getInsets();
        DROP_DOWN_ICON.paintIcon((Component)((Object)this), g, this.getWidth() - DROP_DOWN_ICON.getIconWidth() - DROP_DOWN_ICON_MARGIN_RIGHT, (this.getHeight() - DROP_DOWN_ICON.getIconHeight() - insets.bottom - insets.top) / 2);
    }

    protected int iconTextSpace() {
        return ICON_TEXT_SPACE;
    }

    public void setSelected(boolean selected) {
        this.myIsSelected = selected;
        this.repaint();
    }

    public void setText(String text) {
        this.myPresentation.setText(text);
    }

    public String getText() {
        return this.myPresentation.getText();
    }
}

