/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.hchart;

import com.android.tools.adtui.chart.hchart.HRenderer;
import com.android.tools.adtui.chart.hchart.Method;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.regex.Pattern;

public class JavaMethodHRenderer
extends HRenderer<Method> {
    private static final Pattern dotPattern = Pattern.compile("\\.");

    protected boolean isMethodPlatform(Method method) {
        return method.getNameSpace().startsWith("android.");
    }

    protected boolean isMethodVendor(Method method) {
        return method.getNameSpace().startsWith("java.") || method.getNameSpace().startsWith("sun.") || method.getNameSpace().startsWith("javax.") || method.getNameSpace().startsWith("apple.") || method.getNameSpace().startsWith("com.apple.");
    }

    @Override
    protected Color getFillColor(Method m) {
        if (this.isMethodVendor(m)) {
            return fillVendorColor;
        }
        if (this.isMethodPlatform(m)) {
            return fillPlatformColor;
        }
        return fillAppColor;
    }

    @Override
    protected Color getBordColor(Method m) {
        if (this.isMethodVendor(m)) {
            return bordVendorColor;
        }
        if (this.isMethodPlatform(m)) {
            return bordPlatformColor;
        }
        return bordAppColor;
    }

    @Override
    protected String generateFittingText(Method node, Rectangle2D rect, FontMetrics fontMetrics) {
        String fullyQualified = node.getNameSpace() + "." + node.getName();
        if ((double)fontMetrics.stringWidth(fullyQualified) < rect.getWidth()) {
            return fullyQualified;
        }
        String abbrevPackage = this.getShortPackageName(node.getNameSpace()) + "." + node.getName();
        if ((double)fontMetrics.stringWidth(abbrevPackage) < rect.getWidth()) {
            return abbrevPackage;
        }
        if ((double)fontMetrics.stringWidth(node.getName()) < rect.getWidth()) {
            return node.getName();
        }
        return "";
    }

    @Override
    protected void renderText(Graphics2D g, String text, Rectangle2D.Float rect, FontMetrics fontMetrics) {
        float textPositionY = (float)(rect.getY() + (double)fontMetrics.getAscent());
        g.drawString(text, rect.x, textPositionY);
    }

    protected String getShortPackageName(String nameSpace) {
        if (nameSpace == null || nameSpace.equals("")) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        String[] elements = dotPattern.split(nameSpace);
        String separator = "";
        for (int i = 0; i < elements.length; ++i) {
            b.append(separator);
            b.append(elements[i].charAt(0));
            separator = ".";
        }
        return b.toString();
    }
}

