/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.linechart;

import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineChartCustomRenderer;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DurationData;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DurationDataRenderer<E extends DurationData>
extends AspectObserver
implements LineChartCustomRenderer {
    static final float EPSILON = 1.0E-6f;
    private static final int CLICK_REGION_PADDING_Y = 2;
    private static final int CLICK_REGION_PADDING_X = 4;
    @NotNull
    private DurationDataModel<E> myModel;
    @NotNull
    private final Color myColor;
    @Nullable
    private final Color myDurationBgColor;
    @Nullable
    private Icon myIcon = null;
    @Nullable
    private Stroke myStroke = null;
    @Nullable
    private Function<E, String> myLabelProvider = null;
    @Nullable
    private Consumer<E> myClickHandler = null;
    @Nullable
    private Color myLabelBgColor = null;
    @Nullable
    private Color myLabelHoveredBgColor = null;
    @Nullable
    private Color myLabelClickedBgColor = null;
    @Nullable
    private Color myLabelTextColor = null;
    private float myLineStrokeOffset;
    private float myLabelXOffset;
    private float myLabelYOffset;
    @NotNull
    private final List<Rectangle2D.Float> myPathCache = new ArrayList<Rectangle2D.Float>();
    @NotNull
    private final List<E> myDataCache = new ArrayList();
    @NotNull
    private final List<JLabel> myLabelCache = new ArrayList<JLabel>();
    @NotNull
    private final Map<RangedContinuousSeries, LineConfig> myCustomLineConfigs = new HashMap<RangedContinuousSeries, LineConfig>();
    @NotNull
    private final List<Rectangle2D.Float> myClickRegionCache = new ArrayList<Rectangle2D.Float>();
    private Point myMousePosition;
    private boolean myClick;

    public DurationDataRenderer(@NotNull DurationDataModel<E> model, @NotNull Builder builder) {
        this.myModel = model;
        this.myColor = builder.myColor;
        this.myDurationBgColor = builder.myDurationBgColor;
        this.myIcon = builder.myIcon;
        this.myStroke = builder.myStroke;
        this.myLabelProvider = builder.myLabelProvider;
        this.myClickHandler = builder.myClickHandler;
        this.myLabelBgColor = builder.myLabelBgColor;
        this.myLabelHoveredBgColor = builder.myLabelHoveredBgColor;
        this.myLabelClickedBgColor = builder.myLabelClickedBgColor;
        this.myLabelTextColor = builder.myLabelTextColor;
        this.myLabelXOffset = builder.myLabelXOffset;
        this.myLabelYOffset = builder.myLabelYOffset;
        if (this.myStroke instanceof BasicStroke) {
            BasicStroke stroke = (BasicStroke)this.myStroke;
            this.myLineStrokeOffset = stroke.getLineWidth() / 2.0f;
        } else {
            this.myLineStrokeOffset = 0.0f;
        }
        this.myModel.addDependency(this).onChange(DurationDataModel.Aspect.DURATION_DATA, this::modelChanged);
    }

    public void addCustomLineConfig(@NotNull RangedContinuousSeries series, @NotNull LineConfig config) {
        this.myCustomLineConfigs.put(series, config);
    }

    LineConfig getCustomLineConfig(@NotNull RangedContinuousSeries series) {
        return this.myCustomLineConfigs.get(series);
    }

    private void modelChanged() {
        this.myDataCache.clear();
        this.myClickRegionCache.clear();
        this.myPathCache.clear();
        this.myLabelCache.clear();
        RangedSeries<E> series = this.myModel.getSeries();
        RangedContinuousSeries attached = this.myModel.getAttachedSeries();
        double xMin = series.getXRange().getMin();
        double xLength = series.getXRange().getLength();
        List<SeriesData<E>> seriesList = series.getSeries();
        List attachedSeriesList = attached != null ? attached.getSeries() : null;
        int j = 0;
        SeriesData lastFoundData = null;
        for (int i = 0; i < seriesList.size(); ++i) {
            Rectangle2D.Float rect = new Rectangle2D.Float();
            SeriesData<E> data = seriesList.get(i);
            double yStart = 1.0;
            double xStart = ((double)data.x - xMin) / xLength;
            double xDuration = (double)((DurationData)data.value).getDuration() / xLength;
            rect.setRect(xStart, 0.0, xDuration, 1.0);
            this.myPathCache.add(rect);
            this.myDataCache.add(data.value);
            Rectangle2D.Float clickRegion = new Rectangle2D.Float();
            this.myClickRegionCache.add(clickRegion);
            if (attachedSeriesList != null) {
                double yMin = attached.getYRange().getMin();
                double yMax = attached.getYRange().getMax();
                while (j < attachedSeriesList.size()) {
                    SeriesData seriesData = attachedSeriesList.get(j);
                    if ((float)(seriesData.x - data.x) > 1.0E-6f) {
                        if (lastFoundData == null) break;
                        assert (this.myModel.getInterpolatable() != null);
                        double adjustedY = this.myModel.getInterpolatable().interpolate(lastFoundData, seriesData, data.x);
                        yStart = 1.0 - (adjustedY - yMin) / (yMax - yMin);
                        break;
                    }
                    lastFoundData = seriesData;
                    ++j;
                }
            }
            double regionWidth = 0.0;
            double regionHeight = 0.0;
            if (this.myIcon != null) {
                regionWidth += (double)this.myIcon.getIconWidth();
                regionHeight += (double)this.myIcon.getIconHeight();
            }
            if (this.myLabelProvider != null) {
                JLabel label = new JLabel(this.myLabelProvider.apply(data.value));
                label.setFont((Font)AdtUiUtils.DEFAULT_FONT.deriveFont(9.0f));
                label.setForeground(this.myLabelTextColor);
                Dimension size = label.getPreferredSize();
                label.setBounds(0, 0, size.width, size.height);
                this.myLabelCache.add(label);
                regionWidth += size.getWidth();
                regionHeight = Math.max(regionHeight, size.getHeight());
            }
            if (!(regionWidth > 0.0)) continue;
            clickRegion.setRect(xStart, yStart, regionWidth, regionHeight);
        }
    }

    @Override
    public void renderLines(@NotNull LineChart lineChart, @NotNull Graphics2D g2d, @NotNull List<Path2D> transformedPaths, @NotNull List<RangedContinuousSeries> series) {
        if (this.myDurationBgColor != null || !this.myCustomLineConfigs.isEmpty()) {
            Shape originalClip = g2d.getClip();
            Dimension dim = lineChart.getSize();
            Rectangle2D.Float clipRect = new Rectangle2D.Float();
            ArrayList<LineConfig> configs = new ArrayList<LineConfig>(series.size());
            for (RangedContinuousSeries rangedSeries : series) {
                LineConfig config = lineChart.getLineConfig(rangedSeries);
                if (this.myCustomLineConfigs.containsKey(rangedSeries)) {
                    LineConfig customConfig = this.myCustomLineConfigs.get(rangedSeries);
                    if (config.isAdjustDash() && customConfig.isAdjustDash()) {
                        customConfig.setAdjustedDashPhase(config.getAdjustedDashPhase());
                    }
                    config = customConfig;
                }
                configs.add(config);
            }
            for (Rectangle2D.Float rect : this.myPathCache) {
                double scaledXStart = (double)rect.x * dim.getWidth();
                double scaledXDuration = (double)rect.width * dim.getWidth();
                double newX = Math.max(scaledXStart, originalClip.getBounds().getX());
                ((Rectangle2D)clipRect).setRect(newX, 0.0, Math.min(scaledXDuration + scaledXStart - newX, originalClip.getBounds().getX() + originalClip.getBounds().getWidth() - newX), dim.getHeight());
                g2d.setColor(this.myDurationBgColor == null ? lineChart.getBackground() : this.myDurationBgColor);
                g2d.fill(clipRect);
                g2d.setClip(clipRect);
                LineChart.drawLines(g2d, transformedPaths, configs);
                g2d.setClip(originalClip);
            }
        }
        if (this.myStroke != null) {
            g2d.setColor(this.myColor);
            g2d.setStroke(this.myStroke);
            Line2D.Float eventLine = new Line2D.Float();
            for (int i = 0; i < this.myPathCache.size(); ++i) {
                Rectangle2D.Float rect = this.myPathCache.get(i);
                double scaledXStart = rect.x * (float)lineChart.getWidth();
                double scaledXDuration = rect.width * (float)lineChart.getWidth();
                g2d.translate(scaledXStart, 0.0);
                ((Line2D)eventLine).setLine(0.0, 0.0, 0.0, lineChart.getHeight());
                g2d.draw(eventLine);
                ((Line2D)eventLine).setLine(scaledXDuration, 0.0, scaledXDuration, lineChart.getHeight());
                g2d.draw(eventLine);
                g2d.translate(-scaledXStart, 0.0);
            }
        }
    }

    public void renderOverlay(@NotNull Component host, @NotNull Graphics2D g2d) {
        assert (this.myClickRegionCache.size() == this.myDataCache.size());
        for (int i = 0; i < this.myClickRegionCache.size(); ++i) {
            Rectangle2D.Float rect = this.myClickRegionCache.get(i);
            float paddedHeight = rect.height + 4.0f;
            float paddedWidth = rect.width + 8.0f;
            float scaledStartX = rect.x * (float)host.getWidth() + this.myLabelXOffset + this.myLineStrokeOffset;
            float scaledStartY = this.getClampedLabelY(rect.y, paddedHeight, host.getHeight());
            if (this.myLabelBgColor != null) {
                g2d.setColor(this.myLabelBgColor);
                Rectangle2D.Float scaledRect = new Rectangle2D.Float(scaledStartX, scaledStartY, paddedWidth, paddedHeight);
                if (this.myMousePosition != null && scaledRect.contains(this.myMousePosition)) {
                    g2d.setColor(this.myClick && this.myClickHandler != null ? this.myLabelClickedBgColor : this.myLabelHoveredBgColor);
                }
                g2d.fill(scaledRect);
            }
            g2d.translate(scaledStartX += 4.0f, scaledStartY += 2.0f);
            if (this.myIcon != null) {
                this.myIcon.paintIcon(host, g2d, 0, 0);
                float shift = this.myIcon.getIconWidth();
                g2d.translate(shift, 0.0);
                scaledStartX += shift;
            }
            if (this.myLabelProvider != null) {
                this.myLabelCache.get(i).paint(g2d);
            }
            g2d.translate(-scaledStartX, -scaledStartY);
        }
        this.myClick = false;
    }

    public boolean handleMouseEvent(@NotNull MouseEvent event) {
        this.myMousePosition = event.getPoint();
        boolean bl = this.myClick = event.getClickCount() > 0;
        if (this.myClickHandler == null || !this.myClick) {
            return false;
        }
        assert (this.myDataCache.size() == this.myClickRegionCache.size());
        DurationData hitData = null;
        Dimension dim = event.getComponent().getSize();
        for (int i = 0; i < this.myClickRegionCache.size(); ++i) {
            Rectangle2D.Float rect = this.myClickRegionCache.get(i);
            float paddedHeight = rect.height + 4.0f;
            float paddedWidth = rect.width + 8.0f;
            float scaledY = this.getClampedLabelY(rect.y, paddedHeight, dim.height);
            Rectangle2D.Float scaledRect = new Rectangle2D.Float(rect.x * (float)dim.width + this.myLabelXOffset + this.myLineStrokeOffset, scaledY, paddedWidth, paddedWidth);
            if (!scaledRect.contains(this.myMousePosition)) continue;
            hitData = (DurationData)this.myDataCache.get(i);
            break;
        }
        if (hitData != null) {
            this.myClickHandler.accept(hitData);
            return true;
        }
        return false;
    }

    private float getClampedLabelY(float normalizedY, float height, int hostHeight) {
        float maxScaledY = (float)hostHeight - height;
        float scaledY = normalizedY * (float)hostHeight - height + this.myLabelYOffset;
        return Math.max(0.0f, Math.min(scaledY, maxScaledY));
    }

    List<Rectangle2D.Float> GetDurationDataRegions() {
        return this.myClickRegionCache;
    }

    public static class Builder<E extends DurationData> {
        @NotNull
        private final DurationDataModel<E> myModel;
        @NotNull
        private final Color myColor;
        @Nullable
        private Color myDurationBgColor;
        @Nullable
        private Icon myIcon = null;
        @Nullable
        private Stroke myStroke = null;
        @Nullable
        private Function<E, String> myLabelProvider = null;
        @Nullable
        private Consumer<E> myClickHandler = null;
        @Nullable
        private Color myLabelBgColor = null;
        @Nullable
        private Color myLabelHoveredBgColor = null;
        @Nullable
        private Color myLabelClickedBgColor = null;
        @Nullable
        private Color myLabelTextColor = null;
        private float myLabelXOffset;
        private float myLabelYOffset;

        public Builder(@NotNull DurationDataModel<E> model, @NotNull Color color) {
            this.myModel = model;
            this.myColor = color;
        }

        public Builder<E> setDurationBg(@NotNull Color durationBgColor) {
            this.myDurationBgColor = durationBgColor;
            return this;
        }

        public Builder<E> setIcon(@NotNull Icon icon) {
            this.myIcon = icon;
            return this;
        }

        public Builder<E> setStroke(@NotNull Stroke stroke) {
            this.myStroke = stroke;
            return this;
        }

        public Builder<E> setLabelProvider(@NotNull Function<E, String> provider) {
            this.myLabelProvider = provider;
            return this;
        }

        public Builder<E> setClickHander(@NotNull Consumer<E> handler) {
            this.myClickHandler = handler;
            return this;
        }

        public Builder<E> setLabelColors(@NotNull Color bgColor, @NotNull Color hoveredColor, @NotNull Color clickedColor, @NotNull Color color) {
            this.myLabelBgColor = bgColor;
            this.myLabelHoveredBgColor = hoveredColor;
            this.myLabelClickedBgColor = clickedColor;
            this.myLabelTextColor = color;
            return this;
        }

        public Builder<E> setLabelOffsets(float xOffset, float yOffset) {
            this.myLabelXOffset = xOffset;
            this.myLabelYOffset = yOffset;
            return this;
        }

        @NotNull
        public DurationDataRenderer<E> build() {
            return new DurationDataRenderer<E>(this.myModel, this);
        }
    }
}

