/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.linechart;

import com.android.tools.adtui.LegendConfig;
import com.intellij.ui.JBColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import org.jetbrains.annotations.NotNull;

public class LineConfig {
    public static final BasicStroke DEFAULT_LINE_STROKE = new BasicStroke(2.0f);
    public static final BasicStroke DEFAULT_DASH_STROKE = new BasicStroke(2.0f, 2, 2, 10.0f, new float[]{4.0f, 6.0f}, 0.0f);
    private static final Color[] COLORS = new Color[]{new JBColor(7057110, 7057110), new JBColor(0xFF0000, 0xFF0000), new JBColor(16616764, 16616764), new JBColor(65442, 65442), new JBColor(4080, 4080), new JBColor(13101504, 13101504), new JBColor(10394312, 10394312), new JBColor(14342891, 14342891), new JBColor(0x969696, 0x969696), new JBColor(0xD9D9D9, 0xD9D9D9)};
    private boolean myIsStepped = false;
    private boolean myIsFilled = false;
    private boolean myIsStacked = false;
    private boolean myAdjustDash = false;
    private boolean myIsDash = false;
    private float myDashLength = 0.0f;
    private double myAdjustedDashPhase = 0.0;
    @NotNull
    private LegendConfig.IconType myLegendIconType;
    @NotNull
    private Stroke myStroke;
    @NotNull
    private Color mColor;

    public LineConfig(@NotNull Color color) {
        this.mColor = color;
        this.myStroke = DEFAULT_LINE_STROKE;
        this.myLegendIconType = LegendConfig.IconType.NONE;
    }

    public static LineConfig copyOf(@NotNull LineConfig otherConfig) {
        LineConfig config = new LineConfig(otherConfig.getColor());
        config.setStepped(otherConfig.isStepped());
        config.setFilled(otherConfig.isFilled());
        config.setStacked(otherConfig.isStacked());
        config.setAdjustDash(otherConfig.isAdjustDash());
        config.setLegendIconType(otherConfig.getLegendIconType());
        config.setStroke(otherConfig.getStroke());
        config.setAdjustedDashPhase(otherConfig.getAdjustedDashPhase());
        return config;
    }

    @NotNull
    public LineConfig setStepped(boolean isStepped) {
        this.myIsStepped = isStepped;
        return this;
    }

    public boolean isStepped() {
        return this.myIsStepped;
    }

    @NotNull
    public LineConfig setFilled(boolean isFilled) {
        this.myIsFilled = isFilled;
        return this;
    }

    public boolean isFilled() {
        return this.myIsFilled;
    }

    @NotNull
    public LineConfig setStacked(boolean isStacked) {
        this.myIsStacked = isStacked;
        return this;
    }

    public boolean isStacked() {
        return this.myIsStacked;
    }

    @NotNull
    public LineConfig setAdjustDash(boolean adjustDash) {
        this.myAdjustDash = adjustDash;
        return this;
    }

    public boolean isAdjustDash() {
        return this.myAdjustDash;
    }

    public boolean isDash() {
        return this.myIsDash;
    }

    public float getDashLength() {
        return this.myDashLength;
    }

    public void setAdjustedDashPhase(double dashPhase) {
        this.myAdjustedDashPhase = dashPhase;
    }

    public double getAdjustedDashPhase() {
        return this.myAdjustedDashPhase;
    }

    @NotNull
    public Color getColor() {
        return this.mColor;
    }

    @NotNull
    public LineConfig setColor(@NotNull Color color) {
        this.mColor = color;
        return this;
    }

    @NotNull
    public LineConfig setStroke(@NotNull Stroke stroke) {
        this.myStroke = stroke;
        if (this.myStroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)this.myStroke;
            float[] dashArray = basicStroke.getDashArray();
            this.myAdjustDash = this.myIsDash = dashArray != null;
            this.myDashLength = 0.0f;
            if (this.myIsDash) {
                for (float value : dashArray) {
                    this.myDashLength += value;
                }
            }
        } else {
            this.myIsDash = false;
            this.myDashLength = 0.0f;
        }
        return this;
    }

    @NotNull
    public Stroke getStroke() {
        return this.myStroke;
    }

    @NotNull
    public Stroke getAdjustedStroke() {
        if (!(this.myStroke instanceof BasicStroke) || !this.myAdjustDash) {
            return this.myStroke;
        }
        BasicStroke stroke = (BasicStroke)this.myStroke;
        return new BasicStroke(stroke.getLineWidth(), stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit(), stroke.getDashArray(), (float)this.myAdjustedDashPhase);
    }

    public LineConfig setLegendIconType(@NotNull LegendConfig.IconType legendIconType) {
        this.myLegendIconType = legendIconType;
        return this;
    }

    @NotNull
    public LegendConfig.IconType getLegendIconType() {
        return this.myLegendIconType;
    }

    @NotNull
    public static Color getColor(int index) {
        return COLORS[index % COLORS.length];
    }
}

