/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.linechart;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.chart.linechart.DurationDataRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class OverlayComponent
extends AnimatedComponent {
    @NotNull
    private final ArrayList<DurationDataRenderer> myDurationRenderers = new ArrayList();
    @NotNull
    private final Component myDispatchComponent;

    public OverlayComponent(@NotNull Component dispatchComponent) {
        this.myDispatchComponent = dispatchComponent;
        this.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                OverlayComponent.this.handleOrDispatchEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                OverlayComponent.this.myDispatchComponent.dispatchEvent(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                OverlayComponent.this.myDispatchComponent.dispatchEvent(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                OverlayComponent.this.myDispatchComponent.dispatchEvent(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                OverlayComponent.this.myDispatchComponent.dispatchEvent(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                OverlayComponent.this.myDispatchComponent.dispatchEvent(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                OverlayComponent.this.handleOrDispatchEvent(e);
            }
        });
    }

    public void addDurationDataRenderer(@NotNull DurationDataRenderer renderer) {
        this.myDurationRenderers.add(renderer);
    }

    @Override
    protected void draw(Graphics2D g, Dimension size) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (DurationDataRenderer renderer : this.myDurationRenderers) {
            renderer.renderOverlay(this, g);
        }
    }

    private void handleOrDispatchEvent(MouseEvent e) {
        boolean handled = false;
        for (DurationDataRenderer renderer : this.myDurationRenderers) {
            if (handled |= renderer.handleMouseEvent(e)) break;
        }
        if (!handled) {
            this.myDispatchComponent.dispatchEvent(e);
        }
    }
}

