/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.statechart;

import com.android.tools.adtui.chart.statechart.StateChartReducer;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DefaultStateChartReducer<E extends Enum<E>>
implements StateChartReducer<E> {
    @Override
    public void reduce(@NotNull List<Shape> rectangles, @NotNull List<E> values) {
        int index = 0;
        int keepIndex = 0;
        while (index < rectangles.size()) {
            Shape shape = rectangles.get(index);
            Enum value = (Enum)values.get(index);
            Rectangle2D bounds = shape.getBounds2D();
            if (Math.floor(bounds.getMinX()) < Math.floor(bounds.getMaxX())) {
                rectangles.set(keepIndex, shape);
                values.set(keepIndex, value);
                ++keepIndex;
                ++index;
                continue;
            }
            int pixel = (int)Math.floor(bounds.getMaxX());
            HashMap<Enum, Float> occurrenceWidth = new HashMap<Enum, Float>();
            float minX = (float)bounds.getMinX();
            float maxX = Float.MIN_VALUE;
            float minY = (float)bounds.getMinY();
            float maxY = (float)bounds.getMaxY();
            while (index < rectangles.size()) {
                shape = rectangles.get(index);
                value = (Enum)values.get(index);
                bounds = shape.getBounds2D();
                if ((int)Math.floor(bounds.getMinX()) != pixel || (int)Math.floor(bounds.getMaxX()) != pixel) break;
                maxX = (float)bounds.getMaxX();
                Float width = (Float)occurrenceWidth.get(value);
                occurrenceWidth.put(value, Float.valueOf((width == null ? 0.0f : width.floatValue()) + (float)bounds.getWidth()));
                ++index;
            }
            Enum mostOccurred = null;
            float mostOccurredWidth = -1.0f;
            for (Map.Entry entry : occurrenceWidth.entrySet()) {
                if (!(((Float)entry.getValue()).floatValue() > mostOccurredWidth)) continue;
                mostOccurredWidth = ((Float)entry.getValue()).floatValue();
                mostOccurred = (Enum)entry.getKey();
            }
            if (mostOccurred == null) continue;
            values.set(keepIndex, mostOccurred);
            rectangles.set(keepIndex, new Rectangle2D.Float(minX, minY, maxX - minX, maxY - minY));
            ++keepIndex;
        }
        rectangles.subList(keepIndex, rectangles.size()).clear();
        values.subList(keepIndex, values.size()).clear();
    }
}

