/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.Updater;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AxisComponentModel
extends AspectModel<Aspect>
implements Updatable {
    @NotNull
    private final Range myRange;
    @NotNull
    private final BaseAxisFormatter myFormatter;
    @Nullable
    private Range myGlobalRange;
    private boolean myClampToMajorTicks = false;
    @NotNull
    private String myLabel = "";
    private boolean myFirstUpdate = true;

    public AxisComponentModel(@NotNull Range range, @NotNull BaseAxisFormatter formatter) {
        this.myRange = range;
        this.myFormatter = formatter;
    }

    @Override
    public void update(long elapsedNs) {
        if (this.myClampToMajorTicks) {
            double maxTarget = this.myRange.getMax() - this.getZero();
            double rangeTarget = this.myRange.getLength();
            long majorInterval = this.myFormatter.getMajorInterval(rangeTarget);
            float majorNumTicksTarget = (float)Math.ceil(maxTarget / (double)majorInterval);
            double clampedMaxTarget = majorNumTicksTarget * (float)majorInterval;
            float fraction = this.myFirstUpdate ? 1.0f : 0.99f;
            this.myRange.setMax(Updater.lerp(this.myRange.getMax(), clampedMaxTarget += this.getZero(), fraction, elapsedNs, (double)((float)(clampedMaxTarget * (double)0.001f))));
        }
        this.myFirstUpdate = false;
        this.changed(Aspect.AXIS);
    }

    public void setGlobalRange(@NotNull Range globalRange) {
        this.myGlobalRange = globalRange;
    }

    public void setLabel(@NotNull String label) {
        this.myLabel = label;
    }

    public void setClampToMajorTicks(boolean clampToMajorTicks) {
        this.myClampToMajorTicks = clampToMajorTicks;
    }

    @NotNull
    public String getLabel() {
        return this.myLabel;
    }

    @NotNull
    public Range getRange() {
        return this.myRange;
    }

    @Nullable
    public Range getGlobalRange() {
        return this.myGlobalRange;
    }

    @NotNull
    public BaseAxisFormatter getFormatter() {
        return this.myFormatter;
    }

    public double getZero() {
        return this.myGlobalRange != null ? this.myGlobalRange.getMin() : this.myRange.getMin();
    }

    public static enum Aspect {
        AXIS;

    }
}

