/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import gnu.trove.TLongArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public abstract class BaseDataSeries<E>
implements DataSeries<E> {
    @NotNull
    protected final TLongArrayList mX = new TLongArrayList();

    @NotNull
    private List<SeriesData<E>> getDataSubList(int fromIndex, int toIndex) {
        return IntStream.range(fromIndex, toIndex).mapToObj(index -> new SeriesData<E>(this.getX(index), this.getY(index))).collect(Collectors.toList());
    }

    @Override
    public List<SeriesData<E>> getDataForXRange(Range xRange) {
        if (this.size() == 0 || xRange.isEmpty()) {
            return this.getDataSubList(0, 0);
        }
        int fromIndex = this.getNearestXIndex((long)xRange.getMin());
        int toIndex = this.getNearestXIndex((long)xRange.getMax()) + 1;
        return this.getDataSubList(fromIndex, toIndex);
    }

    public List<SeriesData<E>> getAllData() {
        return this.getDataSubList(0, this.size());
    }

    public abstract void add(long var1, E var3);

    public int size() {
        return this.mX.size();
    }

    public long getX(int index) {
        return this.mX.get(index);
    }

    public abstract E getY(int var1);

    public int getNearestXIndex(long x) {
        int index = this.mX.binarySearch(x);
        if (index < 0) {
            index = -index - 2;
        }
        return Math.max(0, Math.min(index, this.size() - 1));
    }
}

