/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.formatter;

import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import gnu.trove.TIntArrayList;
import org.jetbrains.annotations.NotNull;

public final class MemoryAxisFormatter
extends BaseAxisFormatter {
    private static final int MULTIPLIER = 1024;
    private static final int BASE = 2;
    private static final int[] MIN_INTERVALS = new int[]{4, 1, 1};
    private static String[] UNITS = new String[]{"KB", "MB", "GB"};
    private static final TIntArrayList BASE_FACTORS = new TIntArrayList(new int[]{2, 1});
    public static final MemoryAxisFormatter DEFAULT = new MemoryAxisFormatter(4, 10, 5);

    public MemoryAxisFormatter(int maxMinorTicks, int maxMajorTicks, int switchThreshold) {
        super(maxMinorTicks, maxMajorTicks, switchThreshold, true);
    }

    @Override
    protected int getNumUnits() {
        return UNITS.length;
    }

    @Override
    @NotNull
    protected String getUnit(int index) {
        return UNITS[index];
    }

    @Override
    protected int getUnitBase(int index) {
        return 2;
    }

    @Override
    protected int getUnitMultiplier(int index) {
        return 1024;
    }

    @Override
    protected int getUnitMinimalInterval(int index) {
        return MIN_INTERVALS[index];
    }

    @Override
    @NotNull
    protected TIntArrayList getUnitBaseFactors(int index) {
        return BASE_FACTORS;
    }
}

