/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.formatter;

import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import gnu.trove.TIntArrayList;
import org.jetbrains.annotations.NotNull;

public final class TimeAxisFormatter
extends BaseAxisFormatter {
    private static final int[] MULTIPLIERS = new int[]{1000, 1000, 60, 60, 24};
    private static final int[] BASES = new int[]{10, 10, 60, 60, 24};
    private static final int[] MIN_INTERVALS = new int[]{10, 10, 1, 1, 1};
    private static final String[] UNITS = new String[]{"us", "ms", "s", "m", "h"};
    private static final TIntArrayList[] BASE_FACTORS;
    public static final TimeAxisFormatter DEFAULT;
    public static final TimeAxisFormatter DEFAULT_WITHOUT_MINOR_TICKS;

    public TimeAxisFormatter(int maxMinorTicks, int maxMajorTicks, int switchThreshold) {
        super(maxMinorTicks, maxMajorTicks, switchThreshold);
    }

    @Override
    @NotNull
    public String getFormattedString(double globalRange, double value, boolean includeUnit) {
        if (!includeUnit) {
            return super.getFormattedString(globalRange, value, includeUnit);
        }
        int index1 = this.getMultiplierIndex(globalRange, 1);
        long scale1 = this.getMultiplier();
        String unit1 = this.getUnit(index1);
        if (index1 > 1) {
            int index2 = index1 - 1;
            long scale2 = scale1 / (long)this.getUnitMultiplier(index2);
            String unit2 = this.getUnit(index2);
            int value1 = (int)(value / (double)scale1);
            float value2 = (float)(value - (double)((long)value1 * scale1)) / (float)scale2;
            if (value2 > 0.0f) {
                if (value1 > 0) {
                    return String.format("%d%s%.2f%s", value1, unit1, Float.valueOf(value2), unit2);
                }
                return String.format("%.2f%s", Float.valueOf(value2), unit2);
            }
            return String.format("%d%s", value1, unit1);
        }
        return String.format("%.2f%s", value / (double)scale1, unit1);
    }

    @NotNull
    public String getFixedPointFormattedString(long fixedPoint, long value) {
        long cumulativeScale;
        int baseIndex = this.getMultiplierIndex(fixedPoint, 1);
        long baseScale = this.getMultiplier();
        long factor = value / baseScale;
        if (factor < 1L) {
            return String.format("0%s", this.getUnit(baseIndex));
        }
        long truncatedValue = factor * baseScale;
        int leadIndex = baseIndex;
        long leadScale = baseScale;
        int i = leadIndex + 1;
        while (i < this.getNumUnits() && truncatedValue >= (cumulativeScale = leadScale * (long)this.getUnitMultiplier(leadIndex))) {
            leadIndex = i++;
            leadScale = cumulativeScale;
        }
        StringBuilder builder = new StringBuilder();
        while (leadIndex >= baseIndex && truncatedValue > 0L) {
            long truncatedFactor = truncatedValue / leadScale;
            if (truncatedFactor != 0L) {
                builder.append(String.format("%d%s", truncatedFactor, this.getUnit(leadIndex)));
            }
            truncatedValue -= truncatedFactor * leadScale;
            leadScale /= (long)this.getUnitMultiplier(leadIndex);
            --leadIndex;
        }
        return builder.toString();
    }

    @Override
    protected int getNumUnits() {
        return UNITS.length;
    }

    @Override
    @NotNull
    protected String getUnit(int index) {
        return UNITS[index];
    }

    @Override
    protected int getUnitBase(int index) {
        return BASES[index];
    }

    @Override
    protected int getUnitMultiplier(int index) {
        return MULTIPLIERS[index];
    }

    @Override
    protected int getUnitMinimalInterval(int index) {
        return MIN_INTERVALS[index];
    }

    @Override
    @NotNull
    protected TIntArrayList getUnitBaseFactors(int index) {
        return BASE_FACTORS[index];
    }

    static {
        DEFAULT = new TimeAxisFormatter(5, 10, 5);
        DEFAULT_WITHOUT_MINOR_TICKS = new TimeAxisFormatter(1, 10, 5);
        int size = BASES.length;
        BASE_FACTORS = new TIntArrayList[size];
        for (int i = 0; i < size; ++i) {
            TimeAxisFormatter.BASE_FACTORS[i] = TimeAxisFormatter.getMultiplierFactors(BASES[i]);
        }
    }
}

