/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.legend;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.updater.Updatable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class LegendComponentModel
extends AspectModel<Aspect>
implements Updatable {
    @NotNull
    private final List<Legend> myLegends;
    private final long mUpdateFrequencyNs;
    private long mElapsedNs;

    public LegendComponentModel(int updateFrequencyMs) {
        this.mUpdateFrequencyNs = TimeUnit.MILLISECONDS.toNanos(updateFrequencyMs);
        this.myLegends = new ArrayList<Legend>();
        this.mElapsedNs = this.mUpdateFrequencyNs;
    }

    @NotNull
    public List<Legend> getLegends() {
        return this.myLegends;
    }

    @Override
    public void update(long elapsedNs) {
        this.mElapsedNs += elapsedNs;
        if (this.mElapsedNs >= this.mUpdateFrequencyNs) {
            this.mElapsedNs = 0L;
            this.changed(Aspect.LEGEND);
        }
    }

    public void add(@NotNull Legend legend) {
        this.myLegends.add(legend);
        this.changed(Aspect.LEGEND);
    }

    public void remove(@NotNull Legend legend) {
        this.myLegends.remove(legend);
        this.changed(Aspect.LEGEND);
    }

    public static enum Aspect {
        LEGEND;

    }
}

