/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.ptable;

import com.android.tools.adtui.ptable.PTable;
import com.android.tools.adtui.ptable.StarState;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PTableItem {
    private PTableItem myParent;

    public int hashCode() {
        return Objects.hash(this.getName(), this.getNamespace());
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof PTableItem)) {
            return false;
        }
        PTableItem item = (PTableItem)other;
        return Objects.equals(this.getName(), item.getName()) && Objects.equals(this.getNamespace(), item.getNamespace());
    }

    public boolean hasChildren() {
        return false;
    }

    public List<PTableItem> getChildren() {
        return Collections.emptyList();
    }

    @NotNull
    public String getChildLabel(@NotNull PTableItem item) {
        return item.getName();
    }

    @Nullable
    public PTableItem getParent() {
        return this.myParent;
    }

    public void setParent(PTableItem parent) {
        this.myParent = parent;
    }

    public boolean isExpanded() {
        return false;
    }

    public void setExpanded(boolean expanded) {
    }

    @Nullable
    public TableCellRenderer getCellRenderer() {
        return null;
    }

    @NotNull
    public StarState getStarState() {
        return StarState.NOT_STAR_ABLE;
    }

    public void setStarState(@NotNull StarState starState) {
    }

    @NotNull
    public abstract String getName();

    @Nullable
    public String getNamespace() {
        return null;
    }

    @Nullable
    public abstract String getValue();

    @Nullable
    public String getResolvedValue() {
        return this.getValue();
    }

    public boolean isDefaultValue(@Nullable String value) {
        return false;
    }

    public abstract void setValue(@Nullable Object var1);

    @Nullable
    public String getTooltipText() {
        return null;
    }

    public boolean isEditable(int col) {
        return false;
    }

    public void mousePressed(@NotNull PTable table, @NotNull MouseEvent event, @NotNull Rectangle rectRightColumn) {
    }

    public void mouseMoved(@NotNull PTable table, @NotNull MouseEvent event, @NotNull Rectangle rectRightColumn) {
    }

    public int getColumnToEdit() {
        return 1;
    }
}

