/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.treegrid;

import com.android.tools.adtui.treegrid.TreeGrid;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeGridSpeedSearch<T>
extends SpeedSearchBase<TreeGrid<T>> {
    private final Function<T, String> myConverter;
    private boolean myWasPopupRecentlyActive;

    public TreeGridSpeedSearch(@NotNull TreeGrid<T> grid) {
        this(grid, null);
    }

    public TreeGridSpeedSearch(@NotNull TreeGrid<T> grid, @Nullable Function<T, String> converter) {
        super(grid);
        this.myConverter = converter;
        this.addChangeListener(event -> this.popupChange());
    }

    protected int getSelectedIndex() {
        int offset = 0;
        List lists = ((TreeGrid)this.myComponent).getLists();
        for (JList list : lists) {
            if (list.getSelectedIndex() > -1) {
                return offset + list.getSelectedIndex();
            }
            offset += list.getModel().getSize();
        }
        return -1;
    }

    @NotNull
    protected Object[] getAllElements() {
        AbstractTreeStructure model = ((TreeGrid)this.myComponent).getModel();
        if (model == null) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        Object root = model.getRootElement();
        Object[] sections = model.getChildElements(root);
        if (sections == null || sections.length == 0) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        return Arrays.stream(sections).flatMap(section -> Arrays.stream(model.getChildElements(section))).toArray();
    }

    @Nullable
    protected String getElementText(@NotNull Object element) {
        if (this.myConverter != null) {
            return this.myConverter.apply(element);
        }
        return element.toString();
    }

    protected void selectElement(@NotNull Object element, String selectedText) {
        ((TreeGrid)this.myComponent).setSelectedElement(element);
    }

    private void popupChange() {
        boolean isPopupCurrentlyActive = this.isPopupActive();
        if (!isPopupCurrentlyActive && this.myWasPopupRecentlyActive && this.focusInTreeGrid()) {
            ((TreeGrid)this.myComponent).requestFocus();
        }
        this.myWasPopupRecentlyActive = isPopupCurrentlyActive;
    }

    private boolean focusInTreeGrid() {
        Component focus = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return focus != null && SwingUtilities.isDescendingFrom(focus, this.myComponent);
    }
}

