/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.ui;

import com.intellij.ui.table.JBTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.stream.IntStream;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixedColumnTable
extends JBTable
implements PropertyChangeListener {
    private int fixedColumnCount;
    private final JTable fixed;

    public FixedColumnTable(@NotNull TableModel model) {
        super(model);
        this.addPropertyChangeListener(this);
        this.fixed = new JBTable(){

            public int getRowHeight() {
                return FixedColumnTable.this.getRowHeight();
            }

            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                if (!toggle && !extend) {
                    FixedColumnTable.clearSelectionAndAnchorAndLead(FixedColumnTable.this.getColumnModel().getSelectionModel());
                }
                super.changeSelection(rowIndex, columnIndex, toggle, extend);
            }
        };
        this.fixed.setAutoCreateColumnsFromModel(false);
        this.fixed.setModel(model);
        this.fixed.setSelectionModel(this.getSelectionModel());
        this.setAutoResizeMode(0);
        this.fixed.setAutoResizeMode(0);
        this.fixed.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@NotNull ComponentEvent event) {
                JViewport fixedViewport = (JViewport)SwingUtilities.getUnwrappedParent(FixedColumnTable.this.fixed);
                Dimension size = fixedViewport.getPreferredSize();
                size.width = FixedColumnTable.this.fixed.getWidth();
                fixedViewport.setPreferredSize(size);
                FixedColumnTable.this.getScrollPane().revalidate();
            }
        });
        this.fixed.setInputMap(0, this.getInputMap(0));
        this.fixed.setActionMap(this.getActionMap());
    }

    public int[] getSelectedColumnModelIndices() {
        return IntStream.concat(Arrays.stream(this.fixed.getSelectedColumns()).map(this.fixed::convertColumnIndexToModel), Arrays.stream(this.getSelectedColumns()).map(arg_0 -> this.convertColumnIndexToModel(arg_0))).toArray();
    }

    public void removeEditor() {
        super.removeEditor();
        this.fixed.removeEditor();
    }

    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        if (!toggle && !extend) {
            FixedColumnTable.clearSelectionAndAnchorAndLead(this.fixed.getColumnModel().getSelectionModel());
        }
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
    }

    private static void clearSelectionAndAnchorAndLead(@NotNull ListSelectionModel selectionModel) {
        selectionModel.clearSelection();
        selectionModel.setAnchorSelectionIndex(-1);
        selectionModel.setLeadSelectionIndex(-1);
    }

    public void setDefaultRenderer(@NotNull Class<?> columnClass, @Nullable TableCellRenderer renderer) {
        super.setDefaultRenderer(columnClass, renderer);
        if (this.fixed != null) {
            this.fixed.setDefaultRenderer(columnClass, renderer);
        }
    }

    public void setDefaultEditor(@NotNull Class<?> columnClass, @NotNull TableCellEditor editor) {
        super.setDefaultEditor(columnClass, editor);
        if (this.fixed != null) {
            this.fixed.setDefaultEditor(columnClass, editor);
        }
    }

    public void setCellSelectionEnabled(boolean cellSelectionEnabled) {
        super.setCellSelectionEnabled(cellSelectionEnabled);
        this.fixed.setCellSelectionEnabled(cellSelectionEnabled);
    }

    public void setRowSorter(@NotNull RowSorter<? extends TableModel> sorter) {
        super.setRowSorter(sorter);
        this.fixed.setRowSorter(sorter);
    }

    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        JScrollPane scrollPane = this.getScrollPane();
        if (scrollPane != null) {
            scrollPane.setViewportBorder(null);
            scrollPane.setRowHeaderView(this.fixed);
            scrollPane.setCorner("UPPER_LEFT_CORNER", this.fixed.getTableHeader());
        }
    }

    @Nullable
    private JScrollPane getScrollPane() {
        Container grandparent;
        Container parent = SwingUtilities.getUnwrappedParent((Component)((Object)this));
        if (parent instanceof JViewport && (grandparent = parent.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)grandparent;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || SwingUtilities.getUnwrappedView(viewport) != this) {
                return null;
            }
            return scrollPane;
        }
        return null;
    }

    public int getTotalColumnCount() {
        return (this.fixed == null ? 0 : this.fixed.getColumnCount()) + this.getColumnCount();
    }

    public void setFixedColumnCount(int fixedColumnCount) {
        this.fixedColumnCount = fixedColumnCount;
        this.updateFixedColumns();
    }

    public void addColumn(@NotNull TableColumn column) {
        if (column.getModelIndex() < this.fixedColumnCount) {
            this.fixed.addColumn(column);
        } else {
            super.addColumn(column);
        }
    }

    public void removeColumn(@NotNull TableColumn column) {
        if (column.getModelIndex() < this.fixedColumnCount) {
            this.fixed.removeColumn(column);
        } else {
            super.removeColumn(column);
        }
    }

    @NotNull
    public TableColumn getColumn(int columnIndex) {
        if (columnIndex < this.fixed.getColumnCount()) {
            return this.fixed.getColumnModel().getColumn(columnIndex);
        }
        return this.getColumnModel().getColumn(columnIndex - this.fixed.getColumnCount());
    }

    @NotNull
    public TableCellRenderer getCellRendererAtModel(int row, int column) {
        if (column < this.fixed.getColumnCount()) {
            return this.fixed.getCellRenderer(this.fixed.convertRowIndexToView(row), this.fixed.convertColumnIndexToView(column));
        }
        return this.getCellRenderer(this.convertRowIndexToView(row), this.convertColumnIndexToView(column));
    }

    @NotNull
    public Object getFixedColumnValueAt(int row, int column) {
        return this.fixed.getValueAt(row, column);
    }

    private void updateFixedColumns() {
        TableColumn col1;
        int col;
        TableColumnModel model1 = this.fixed.getColumnModel();
        TableColumnModel model2 = this.getColumnModel();
        for (col = model1.getColumnCount() - 1; col >= 0; --col) {
            col1 = model1.getColumn(col);
            if (col1.getModelIndex() < this.fixedColumnCount) continue;
            model1.removeColumn(col1);
            model2.addColumn(col1);
            model2.moveColumn(model2.getColumnCount(), 0);
        }
        for (col = 0; col < model2.getColumnCount(); ++col) {
            col1 = model2.getColumn(col);
            if (col1.getModelIndex() >= this.fixedColumnCount) continue;
            model2.removeColumn(col1);
            model1.addColumn(col1);
            --col;
        }
        this.fixed.setPreferredScrollableViewportSize(this.fixed.getPreferredSize());
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        String name = event.getPropertyName();
        if ("selectionModel".equals(name)) {
            this.fixed.setSelectionModel(this.getSelectionModel());
        } else if ("model".equals(name)) {
            this.fixed.setModel(this.getModel());
            this.updateFixedColumns();
        }
    }
}

