/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.validation;

import com.intellij.icons.AllIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Validator<T> {
    @NotNull
    public Result validate(@NotNull T var1);

    public static final class Result {
        public static final Result OK = new Result(Severity.OK, "");
        private final Severity mySeverity;
        private final String myMessage;

        public Result(@NotNull Severity severity, @NotNull String message) {
            this.mySeverity = severity;
            this.myMessage = message;
        }

        @NotNull
        public Severity getSeverity() {
            return this.mySeverity;
        }

        @NotNull
        public String getMessage() {
            return this.myMessage;
        }

        @NotNull
        public static Result fromNullableMessage(@Nullable String errorMessage) {
            return errorMessage == null ? OK : new Result(Severity.ERROR, errorMessage);
        }
    }

    public static enum Severity {
        OK(null),
        INFO(AllIcons.General.BalloonInformation),
        WARNING(AllIcons.General.BalloonWarning),
        ERROR(AllIcons.General.BalloonError);

        @Nullable
        private final Icon myIcon;

        private Severity(Icon icon) {
            this.myIcon = icon;
        }

        @Nullable
        public Icon getIcon() {
            return this.myIcon;
        }
    }
}

