/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.validation;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.validators.TrueValidator;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public final class ValidatorPanel
extends JPanel
implements Disposable {
    private static final String BLANK = " ";
    private final ListenerManager myListeners;
    private final Table<Validator.Severity, ObservableValue<?>, String> myMessages;
    private final BoolProperty myHasErrors;
    private JPanel myRootPanel;
    private JPanel mySouthPanel;
    private JBLabel myValidationLabel;

    public ValidatorPanel(@NotNull Disposable parentDisposable, @NotNull JComponent innerPanel) {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myListeners = new ListenerManager();
        this.myMessages = HashBasedTable.create();
        this.myHasErrors = new BoolValueProperty();
        this.add(this.myRootPanel);
        this.myRootPanel.add(innerPanel);
        this.myValidationLabel.setName("ValidationLabel");
        this.myValidationLabel.setText(BLANK);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public <T> void registerValidator(@NotNull ObservableValue<T> value, @NotNull Validator<T> validator) {
        this.myListeners.listenAndFire(value, sender -> {
            Validator.Result result = validator.validate(value.get());
            this.myMessages.column((Object)value).clear();
            if (result.getSeverity() != Validator.Severity.OK) {
                this.myMessages.put((Object)result.getSeverity(), (Object)value, (Object)result.getMessage());
            }
            this.updateValidationLabel();
        });
    }

    public void registerTest(@NotNull ObservableValue<Boolean> value, @NotNull Validator.Severity severity, @NotNull String message) {
        this.registerValidator(value, new TrueValidator(severity, message));
    }

    public void registerTest(@NotNull ObservableValue<Boolean> value, @NotNull String message) {
        this.registerTest(value, Validator.Severity.ERROR, message);
    }

    public void registerMessageSource(@NotNull ObservableValue<String> message, @NotNull Validator.Severity severity) {
        this.registerValidator(message, value -> {
            if (value.isEmpty()) {
                return Validator.Result.OK;
            }
            return new Validator.Result(severity, (String)value);
        });
    }

    public void registerMessageSource(@NotNull ObservableValue<String> message) {
        this.registerMessageSource(message, Validator.Severity.ERROR);
    }

    @NotNull
    public ObservableBool hasErrors() {
        return this.myHasErrors;
    }

    private void updateValidationLabel() {
        this.myValidationLabel.setIcon(null);
        this.myValidationLabel.setText(BLANK);
        boolean hasErrors = false;
        for (Validator.Severity severity : Validator.Severity.values()) {
            Iterator messages = this.myMessages.row((Object)severity).values().iterator();
            if (!messages.hasNext()) continue;
            this.myValidationLabel.setText((String)messages.next());
            this.myValidationLabel.setIcon(severity.getIcon());
            if (severity != Validator.Severity.ERROR) continue;
            hasErrors = true;
            break;
        }
        this.myHasErrors.set((Object)hasErrors);
    }

    public void dispose() {
        this.myListeners.releaseAll();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 15));
        this.mySouthPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, "South");
        this.myValidationLabel = jBLabel = new JBLabel();
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

