/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.vintage.engine.discovery.DiscoverySelectorResolver;
import org.junit.vintage.engine.discovery.TestClassCollector;
import org.junit.vintage.engine.discovery.UniqueIdFilter;

class UniqueIdSelectorResolver
extends DiscoverySelectorResolver<UniqueIdSelector> {
    private final Logger logger;

    UniqueIdSelectorResolver(Logger logger) {
        super(UniqueIdSelector.class);
        this.logger = logger;
    }

    @Override
    void resolve(UniqueIdSelector selector, TestClassCollector collector) {
        UniqueId uniqueId = selector.getUniqueId();
        if (UniqueId.forEngine((String)"junit-vintage").equals((Object)uniqueId)) {
            this.logger.warning(() -> String.format("Unresolvable Unique ID (%s): Cannot resolve the engine's unique ID", uniqueId));
        } else {
            uniqueId.getEngineId().filter(Predicate.isEqual("junit-vintage")).ifPresent(engineId -> this.determineTestClassName(uniqueId).ifPresent(testClassName -> this.resolveIntoFilteredTestClass((String)testClassName, uniqueId, collector)));
        }
    }

    private void resolveIntoFilteredTestClass(String testClassName, UniqueId uniqueId, TestClassCollector collector) {
        Optional testClass = ReflectionUtils.loadClass((String)testClassName);
        if (testClass.isPresent()) {
            collector.addFiltered((Class)testClass.get(), new UniqueIdFilter(uniqueId));
        } else {
            this.logger.warning(() -> String.format("Unresolvable Unique ID (%s): Unknown class %s", uniqueId, testClassName));
        }
    }

    private Optional<String> determineTestClassName(UniqueId uniqueId) {
        UniqueId.Segment runnerSegment = (UniqueId.Segment)uniqueId.getSegments().get(1);
        if ("runner".equals(runnerSegment.getType())) {
            return Optional.of(runnerSegment.getValue());
        }
        this.logger.warning(() -> String.format("Unresolvable Unique ID (%s): Unique ID segment after engine segment must be of type \"runner\"", uniqueId));
        return Optional.empty();
    }
}

