/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unused;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.unused.ImplicitPropertyUsageProvider;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesInspectionBase;
import com.intellij.lang.properties.PropertiesQuickFixFactory;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.inspections.ResourceBundleEditorInspection;
import com.intellij.lang.properties.editor.inspections.ResourceBundleEditorProblemDescriptor;
import com.intellij.lang.properties.findUsages.PropertySearcher;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedPropertyInspection
extends PropertiesInspectionBase
implements ResourceBundleEditorInspection {
    private static final Logger LOG = Logger.getInstance(UnusedPropertyInspection.class);

    @NotNull
    public String getDisplayName() {
        return PropertiesBundle.message("unused.property.inspection.display.name", new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return "UnusedProperty";
    }

    @Nullable
    private static GlobalSearchScope getWidestUseScope(@Nullable String key, @NotNull Project project, @NotNull Module ownModule) {
        if (key == null) {
            return null;
        }
        LinkedHashSet modules = ContainerUtil.newLinkedHashSet();
        for (IProperty property : PropertiesImplUtil.findPropertiesByKey(project, key)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)property.getPsiElement());
            if (module == null) {
                return GlobalSearchScope.allScope((Project)project);
            }
            if (module == ownModule) continue;
            modules.add(module);
        }
        if (modules.isEmpty()) {
            return null;
        }
        ArrayList list = ContainerUtil.newArrayList((Iterable)modules);
        GlobalSearchScope result = GlobalSearchScope.moduleWithDependentsScope((Module)((Module)list.get(0)));
        for (int i = 1; i < list.size(); ++i) {
            result = result.uniteWith(GlobalSearchScope.moduleWithDependentsScope((Module)((Module)list.get(i))));
        }
        return result;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        PsiFile file = session.getFile();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return super.buildVisitor(holder, isOnTheFly, session);
        }
        final UnusedPropertiesSearchHelper helper = new UnusedPropertiesSearchHelper(module);
        return new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                if (!(element instanceof Property)) {
                    return;
                }
                Property property = (Property)element;
                if (UnusedPropertyInspection.isPropertyUsed(property, helper, isOnTheFly)) {
                    return;
                }
                ASTNode propertyNode = property.getNode();
                assert (propertyNode != null);
                ASTNode[] nodes = propertyNode.getChildren(null);
                Property key = nodes.length == 0 ? property : nodes[0].getPsi();
                LocalQuickFix fix = PropertiesQuickFixFactory.getInstance().createRemovePropertyLocalFix();
                holder.registerProblem((PsiElement)key, PropertiesBundle.message("unused.property.problem.descriptor.name", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{fix});
            }
        };
    }

    @Override
    @NotNull
    public Function<IProperty[], ResourceBundleEditorProblemDescriptor[]> buildPropertyGroupVisitor(@NotNull ResourceBundle resourceBundle) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)resourceBundle.getDefaultPropertiesFile().getContainingFile());
        if (module == null) {
            return x -> null;
        }
        UnusedPropertiesSearchHelper helper = new UnusedPropertiesSearchHelper(module);
        return properties -> {
            ResourceBundleEditorProblemDescriptor[] resourceBundleEditorProblemDescriptorArray;
            if (!UnusedPropertyInspection.isPropertyUsed((Property)properties[0], helper, true)) {
                ResourceBundleEditorProblemDescriptor[] resourceBundleEditorProblemDescriptorArray2 = new ResourceBundleEditorProblemDescriptor[1];
                resourceBundleEditorProblemDescriptorArray = resourceBundleEditorProblemDescriptorArray2;
                resourceBundleEditorProblemDescriptorArray2[0] = new ResourceBundleEditorProblemDescriptor(ProblemHighlightType.LIKE_UNUSED_SYMBOL, PropertiesBundle.message("unused.property.problem.descriptor.name", new Object[0]), new RemovePropertiesFromAllLocalesFix((Property)properties[0]));
            } else {
                resourceBundleEditorProblemDescriptorArray = null;
            }
            return resourceBundleEditorProblemDescriptorArray;
        };
    }

    private static boolean isPropertyUsed(@NotNull Property property, @NotNull UnusedPropertiesSearchHelper helper, boolean isOnTheFly) {
        ProgressIndicator original = ProgressManager.getInstance().getProgressIndicator();
        if (original != null) {
            if (original.isCanceled()) {
                return true;
            }
            original.setText(PropertiesBundle.message("searching.for.property.key.progress.text", property.getUnescapedKey()));
        }
        if (ImplicitPropertyUsageProvider.isImplicitlyUsed(property)) {
            return true;
        }
        String name = property.getName();
        if (name == null) {
            return true;
        }
        if (helper.getSearcher() != null && (name = helper.getSearcher().getKeyToSearch(name, property.getProject())) == null) {
            return true;
        }
        PsiSearchHelper searchHelper = helper.getSearchHelper();
        if (UnusedPropertyInspection.mayHaveUsages((PsiElement)property, name, searchHelper, helper.getOwnUseScope(), isOnTheFly, original)) {
            return true;
        }
        GlobalSearchScope widerScope = UnusedPropertyInspection.getWidestUseScope(property.getKey(), property.getProject(), helper.getModule());
        return widerScope != null && UnusedPropertyInspection.mayHaveUsages((PsiElement)property, name, searchHelper, widerScope, isOnTheFly, original);
    }

    private static boolean mayHaveUsages(@NotNull PsiElement property, @NotNull String name, @NotNull PsiSearchHelper psiSearchHelper, @NotNull GlobalSearchScope searchScope, boolean onTheFly, @Nullable ProgressIndicator indicator) {
        PsiSearchHelper.SearchCostResult cheapEnough = psiSearchHelper.isCheapEnoughToSearch(name, searchScope, null, indicator);
        if (cheapEnough == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES) {
            return false;
        }
        if (onTheFly && cheapEnough == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
            return true;
        }
        return ReferencesSearch.search((PsiElement)property, (SearchScope)searchScope, (boolean)false).findFirst() != null;
    }

    private static class RemovePropertiesFromAllLocalesFix
    implements QuickFix<ResourceBundleEditorProblemDescriptor> {
        private final SmartPsiElementPointer<Property> myRepresentativePointer;

        private RemovePropertiesFromAllLocalesFix(Property property) {
            this.myRepresentativePointer = SmartPointerManager.getInstance((Project)property.getProject()).createSmartPsiElementPointer((PsiElement)property);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return PropertiesBundle.message("remove.property.intention.text", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ResourceBundleEditorProblemDescriptor descriptor) {
            Property element = (Property)this.myRepresentativePointer.getElement();
            if (element == null) {
                return;
            }
            String key = element.getKey();
            if (key == null) {
                return;
            }
            PropertiesFile file = PropertiesImplUtil.getPropertiesFile(this.myRepresentativePointer.getContainingFile());
            LOG.assertTrue(file != null);
            file.getResourceBundle().getPropertiesFiles().stream().flatMap(f -> f.findPropertiesByKey(key).stream()).filter(Objects::nonNull).map(IProperty::getPsiElement).filter(arg_0 -> ((FileModificationService)FileModificationService.getInstance()).preparePsiElementForWrite(arg_0)).forEach(PsiElement::delete);
        }
    }

    private static class UnusedPropertiesSearchHelper {
        private final GlobalSearchScope myOwnUseScope;
        private final Module myModule;
        private final PropertySearcher mySearcher;
        private final PsiSearchHelper mySearchHelper;

        UnusedPropertiesSearchHelper(Module module) {
            this.myOwnUseScope = GlobalSearchScope.moduleWithDependentsScope((Module)module);
            this.myModule = module;
            this.mySearcher = (PropertySearcher)ContainerUtil.find((Object[])Extensions.getExtensions((String)"com.intellij.referencesSearch"), (Condition)new FilteringIterator.InstanceOf(PropertySearcher.class));
            this.mySearchHelper = PsiSearchHelper.SERVICE.getInstance((Project)module.getProject());
        }

        public Module getModule() {
            return this.myModule;
        }

        GlobalSearchScope getOwnUseScope() {
            return this.myOwnUseScope;
        }

        public PropertySearcher getSearcher() {
            return this.mySearcher;
        }

        PsiSearchHelper getSearchHelper() {
            return this.mySearchHelper;
        }
    }
}

