/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PropertyManipulator
extends AbstractElementManipulator<PropertyImpl> {
    public PropertyImpl handleContentChange(@NotNull PropertyImpl element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        TextRange valueRange = this.getRangeInElement(element);
        String oldText = element.getText();
        String newText = oldText.substring(0, range.getStartOffset()) + newContent + oldText.substring(range.getEndOffset());
        element.setValue(newText.substring(valueRange.getStartOffset()).replaceAll("([^\\s])\n", "$1 \n"));
        return element;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull PropertyImpl element) {
        ASTNode valueNode = element.getValueNode();
        if (valueNode == null) {
            return TextRange.from((int)element.getTextLength(), (int)0);
        }
        TextRange range = valueNode.getTextRange();
        return TextRange.from((int)(range.getStartOffset() - element.getTextRange().getStartOffset()), (int)range.getLength());
    }
}

