/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RemovePropertyFix
implements IntentionAction {
    private final SmartPsiElementPointer<Property> myProperty;

    RemovePropertyFix(@NotNull Property origProperty) {
        this.myProperty = SmartPointerManager.getInstance((Project)origProperty.getProject()).createSmartPsiElementPointer((PsiElement)origProperty);
    }

    @NotNull
    public String getText() {
        return PropertiesBundle.message("remove.property.intention.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return file != null && file.isValid() && PsiManager.getInstance((Project)project).isInProject((PsiElement)file) && this.myProperty.getElement() != null;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        return this.myProperty.getElement();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        ((Property)ObjectUtils.notNull((Object)this.myProperty.getElement())).delete();
    }

    public boolean startInWriteAction() {
        return true;
    }
}

