/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleImpl
extends ResourceBundle {
    @NotNull
    private final PropertiesFile myDefaultPropertiesFile;
    private boolean myValid = true;

    public ResourceBundleImpl(@NotNull PropertiesFile defaultPropertiesFile) {
        this.myDefaultPropertiesFile = defaultPropertiesFile;
    }

    @Override
    @NotNull
    public List<PropertiesFile> getPropertiesFiles() {
        return PropertiesImplUtil.getResourceBundleWithCachedFiles(this.myDefaultPropertiesFile).getFiles();
    }

    @Override
    @NotNull
    public PropertiesFile getDefaultPropertiesFile() {
        return this.myDefaultPropertiesFile;
    }

    @Override
    @NotNull
    public String getBaseName() {
        return ResourceBundleManager.getInstance(this.getProject()).getBaseName(this.myDefaultPropertiesFile.getContainingFile());
    }

    @Override
    @NotNull
    public VirtualFile getBaseDirectory() {
        return this.myDefaultPropertiesFile.getParent().getVirtualFile();
    }

    @Override
    public boolean isValid() {
        return this.myValid && this.myDefaultPropertiesFile.getContainingFile().isValid();
    }

    public void invalidate() {
        this.myValid = false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceBundleImpl resourceBundle = (ResourceBundleImpl)o;
        return this.myDefaultPropertiesFile.equals(resourceBundle.myDefaultPropertiesFile);
    }

    public int hashCode() {
        return this.myDefaultPropertiesFile.hashCode();
    }

    public String getUrl() {
        return this.getBaseDirectory() + "/" + this.getBaseName();
    }

    public String toString() {
        return "ResourceBundleImpl:" + this.getBaseName();
    }
}

