/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.create;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.create.CreateResourceBundleDialogComponent;
import com.intellij.lang.properties.projectView.CustomResourceBundlePropertiesFileNode;
import com.intellij.lang.properties.projectView.ResourceBundleNode;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.NotNull;

public class AddNewPropertyFileAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(AddNewPropertyFileAction.class);

    protected AddNewPropertyFileAction() {
        super(PropertiesBundle.message("add.property.files.to.resource.bundle.dialog.action.title", new Object[0]), null, AllIcons.FileTypes.Properties);
    }

    public void update(AnActionEvent e) {
        Navigatable[] data = (Navigatable[])CommonDataKeys.NAVIGATABLE_ARRAY.getData(e.getDataContext());
        if (data != null && data.length == 1 && (data[0] instanceof ResourceBundleNode || data[0] instanceof CustomResourceBundlePropertiesFileNode)) {
            ResourceBundle resourceBundle = (ResourceBundle)((ProjectViewNode)data[0]).getValue();
            LOG.assertTrue(resourceBundle != null);
            if (CreateResourceBundleDialogComponent.getResourceBundlePlacementDirectory(resourceBundle) != null) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
        }
        e.getPresentation().setEnabledAndVisible(false);
    }

    public void actionPerformed(AnActionEvent e) {
        ResourceBundle resourceBundle = AddNewPropertyFileAction.getResourceBundle(e);
        new CreateResourceBundleDialogComponent.Dialog(e.getProject(), null, resourceBundle).show();
    }

    @NotNull
    private static ResourceBundle getResourceBundle(AnActionEvent e) {
        Navigatable[] data = (Navigatable[])CommonDataKeys.NAVIGATABLE_ARRAY.getData(e.getDataContext());
        LOG.assertTrue(data != null && data.length == 1 && (data[0] instanceof ResourceBundleNode || data[0] instanceof CustomResourceBundlePropertiesFileNode));
        Object value = ((ProjectViewNode)data[0]).getValue();
        LOG.assertTrue(value != null);
        return (ResourceBundle)value;
    }
}

