/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ResourceBundleEditorFileListener
extends VirtualFileAdapter {
    private static final Update FORCE_UPDATE = new Update("FORCE_UPDATE"){

        public void run() {
            throw new IllegalStateException();
        }
    };
    private final ResourceBundleEditor myEditor;
    private final MyVfsEventsProcessor myEventsProcessor;
    private final Project myProject;

    public ResourceBundleEditorFileListener(ResourceBundleEditor editor) {
        this.myEditor = editor;
        this.myEventsProcessor = new MyVfsEventsProcessor();
        this.myProject = this.myEditor.getResourceBundle().getProject();
    }

    public void flush() {
        FileDocumentManager.getInstance().saveAllDocuments();
        this.myEventsProcessor.flush();
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        this.myEventsProcessor.queue(event, EventType.FILE_CREATED);
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        this.myEventsProcessor.queue(event, EventType.FILE_DELETED);
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        this.myEventsProcessor.queue((VirtualFileEvent)event, EventType.PROPERTY_CHANGED);
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        this.myEventsProcessor.queue(event, EventType.CONTENT_CHANGED);
    }

    private static class EventWithType {
        private final EventType myType;
        private final VirtualFileEvent myEvent;

        private EventWithType(EventType type, VirtualFileEvent event) {
            this.myType = type;
            this.myEvent = event;
        }

        public EventType getType() {
            return this.myType;
        }

        public VirtualFileEvent getEvent() {
            return this.myEvent;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventWithType type = (EventWithType)o;
            if (this.myType != type.myType) {
                return false;
            }
            return this.myEvent.equals(type.myEvent);
        }

        public int hashCode() {
            int result = this.myType.hashCode();
            result = 31 * result + this.myEvent.hashCode();
            return result;
        }
    }

    private static enum EventType {
        FILE_CREATED,
        FILE_DELETED,
        CONTENT_CHANGED,
        PROPERTY_CHANGED;

    }

    private class SetViewerPropertyRunnable
    implements Runnable {
        private final List<VirtualFile> myFiles = new ArrayList<VirtualFile>();
        private final List<Boolean> myIsViewer = new ArrayList<Boolean>();

        private SetViewerPropertyRunnable() {
        }

        public void addFile(VirtualFile virtualFile, boolean isViewer) {
            this.myFiles.add(virtualFile);
            this.myIsViewer.add(isViewer);
        }

        @Override
        public void run() {
            for (int i = 0; i < this.myFiles.size(); ++i) {
                VirtualFile file = this.myFiles.get(i);
                Boolean viewer = this.myIsViewer.get(i);
                EditorEx editor = ResourceBundleEditorFileListener.this.myEditor.getTranslationEditors().get(file);
                if (editor == null) continue;
                editor.setViewer(viewer.booleanValue());
            }
        }
    }

    private class MyVfsEventsProcessor {
        private final AtomicReference<Set<EventWithType>> myEventQueue = new AtomicReference<Set>(ContainerUtil.newConcurrentSet());
        private final MergingUpdateQueue myUpdateQueue = new MergingUpdateQueue("rbe.vfs.listener.queue", 200, true, ResourceBundleEditorFileListener.access$100(ResourceBundleEditorFileListener.this).getComponent(), (Disposable)ResourceBundleEditorFileListener.access$100(ResourceBundleEditorFileListener.this), ResourceBundleEditorFileListener.access$100(ResourceBundleEditorFileListener.this).getComponent(), false){

            protected void execute(@NotNull Update[] updates) {
                ReadTask task = new ReadTask(){
                    final Set<EventWithType> myEvents;
                    {
                        this.myEvents = MyVfsEventsProcessor.this.myEventQueue.getAndSet(ContainerUtil.newConcurrentSet());
                    }

                    @Nullable
                    public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                        if (!ResourceBundleEditorFileListener.this.myEditor.isValid()) {
                            return null;
                        }
                        Runnable toDo = null;
                        NotNullLazyValue<Set<VirtualFile>> resourceBundleAsSet = new NotNullLazyValue<Set<VirtualFile>>(){

                            @NotNull
                            protected Set<VirtualFile> compute() {
                                return ResourceBundleEditorFileListener.this.myEditor.getResourceBundle().getPropertiesFiles().stream().map(PropertiesFile::getVirtualFile).collect(Collectors.toSet());
                            }
                        };
                        for (EventWithType e : this.myEvents) {
                            if (e.getType() == EventType.FILE_DELETED || e.getType() == EventType.PROPERTY_CHANGED && ((VirtualFilePropertyEvent)e.getEvent()).getPropertyName().equals("name")) {
                                if (!ResourceBundleEditorFileListener.this.myEditor.getTranslationEditors().containsKey(e.getEvent().getFile())) continue;
                                int validFilesCount = 0;
                                for (PropertiesFile file : ResourceBundleEditorFileListener.this.myEditor.getResourceBundle().getPropertiesFiles()) {
                                    if (file.getContainingFile().isValid()) {
                                        ++validFilesCount;
                                    }
                                    if (validFilesCount != 2) continue;
                                    break;
                                }
                                if (validFilesCount > 1) {
                                    toDo = ResourceBundleEditorFileListener.this.myEditor::recreateEditorsPanel;
                                    break;
                                }
                                toDo = () -> {
                                    FileEditorManagerEx fileEditorManager = (FileEditorManagerEx)FileEditorManager.getInstance((Project)ResourceBundleEditorFileListener.this.myProject);
                                    VirtualFile file = fileEditorManager.getFile((FileEditor)ResourceBundleEditorFileListener.this.myEditor);
                                    if (file != null) {
                                        fileEditorManager.closeFile(file);
                                    }
                                };
                                break;
                            }
                            if (e.getType() == EventType.FILE_CREATED) {
                                if (!((Set)resourceBundleAsSet.getValue()).contains(e.getEvent().getFile())) continue;
                                toDo = ResourceBundleEditorFileListener.this.myEditor::recreateEditorsPanel;
                                break;
                            }
                            if (e.getType() == EventType.PROPERTY_CHANGED && ((VirtualFilePropertyEvent)e.getEvent()).getPropertyName().equals("writable")) {
                                if (!ResourceBundleEditorFileListener.this.myEditor.getTranslationEditors().containsKey(e.getEvent().getFile())) continue;
                                if (toDo == null) {
                                    toDo = new SetViewerPropertyRunnable();
                                }
                                if (toDo instanceof SetViewerPropertyRunnable) {
                                    ((SetViewerPropertyRunnable)toDo).addFile(e.getEvent().getFile(), (Boolean)((VirtualFilePropertyEvent)e.getEvent()).getNewValue() == false);
                                    continue;
                                }
                                toDo = ResourceBundleEditorFileListener.this.myEditor::recreateEditorsPanel;
                                break;
                            }
                            if (!ResourceBundleEditorFileListener.this.myEditor.getTranslationEditors().containsKey(e.getEvent().getFile())) continue;
                            if (toDo instanceof SetViewerPropertyRunnable) {
                                toDo = ResourceBundleEditorFileListener.this.myEditor::recreateEditorsPanel;
                                break;
                            }
                            if (toDo != null) continue;
                            toDo = () -> ResourceBundleEditorFileListener.this.myEditor.updateEditorsFromProperties(true);
                        }
                        if (toDo == null) {
                            return null;
                        }
                        Runnable toDoCopy = toDo;
                        return new ReadTask.Continuation(() -> {
                            if (ResourceBundleEditorFileListener.this.myEditor.isValid()) {
                                toDoCopy.run();
                            }
                        }, ModalityState.NON_MODAL);
                    }

                    public void onCanceled(@NotNull ProgressIndicator indicator) {
                        MyVfsEventsProcessor.this.myEventQueue.updateAndGet(s -> {
                            s.addAll(this.myEvents);
                            return s;
                        });
                        MyVfsEventsProcessor.this.myUpdateQueue.queue(FORCE_UPDATE);
                    }
                };
                ProgressIndicatorUtils.scheduleWithWriteActionPriority((ReadTask)task);
            }
        };

        private MyVfsEventsProcessor() {
        }

        public void queue(VirtualFileEvent event, EventType type) {
            this.myEventQueue.updateAndGet(s -> {
                s.add(new EventWithType(type, event));
                return s;
            });
            this.myUpdateQueue.queue(FORCE_UPDATE);
        }

        public void flush() {
            this.myUpdateQueue.flush();
        }
    }
}

