/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.editor.ResourceBundlePropertyStructureViewElement;
import com.intellij.lang.properties.editor.inspections.InspectedPropertyProblems;
import com.intellij.lang.properties.editor.inspections.ResourceBundleEditorInspection;
import com.intellij.lang.properties.editor.inspections.ResourceBundleEditorProblemDescriptor;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Queue;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleEditorHighlighter
implements BackgroundEditorHighlighter {
    private static final Logger LOG = Logger.getInstance(ResourceBundleEditorHighlighter.class);
    private final ResourceBundleEditor myEditor;

    public ResourceBundleEditorHighlighter(ResourceBundleEditor editor) {
        this.myEditor = editor;
    }

    @NotNull
    public HighlightingPass[] createPassesForEditor() {
        return new HighlightingPass[]{new ResourceBundleEditorHighlightingPass(this.myEditor)};
    }

    @NotNull
    public HighlightingPass[] createPassesForVisibleArea() {
        throw new UnsupportedOperationException();
    }

    private static class InspectionVisitorWrapper {
        private final Function<IProperty[], ResourceBundleEditorProblemDescriptor[]> myProblemVisitor;
        private final HighlightSeverity mySeverity;
        private final HighlightDisplayKey myKey;

        private InspectionVisitorWrapper(@NotNull Function<IProperty[], ResourceBundleEditorProblemDescriptor[]> visitor, @NotNull HighlightSeverity severity, @NotNull HighlightDisplayKey key) {
            this.myProblemVisitor = visitor;
            this.mySeverity = severity;
            this.myKey = key;
        }

        public Function<IProperty[], ResourceBundleEditorProblemDescriptor[]> getProblemVisitor() {
            return this.myProblemVisitor;
        }

        public HighlightSeverity getSeverity() {
            return this.mySeverity;
        }

        public HighlightDisplayKey getKey() {
            return this.myKey;
        }
    }

    private static class ResourceBundleEditorHighlightingPass
    implements HighlightingPass {
        private final ResourceBundleEditor myEditor;

        private ResourceBundleEditorHighlightingPass(ResourceBundleEditor editor) {
            this.myEditor = editor;
        }

        public void collectInformation(@NotNull ProgressIndicator progress) {
            InspectionProfileImpl profileToUse = InspectionProfileManager.getInstance().getCurrentProfile();
            PsiFile containingFile = this.myEditor.getResourceBundle().getDefaultPropertiesFile().getContainingFile();
            InspectionVisitorWrapper[] visitors = (InspectionVisitorWrapper[])Arrays.stream(profileToUse.getInspectionTools((PsiElement)containingFile)).filter(arg_0 -> ResourceBundleEditorHighlightingPass.lambda$collectInformation$0((InspectionProfile)profileToUse, containingFile, arg_0)).map(InspectionToolWrapper::getTool).filter(ResourceBundleEditorInspection.class::isInstance).map(ResourceBundleEditorInspection.class::cast).map(arg_0 -> this.lambda$collectInformation$1((InspectionProfile)profileToUse, containingFile, arg_0)).toArray(InspectionVisitorWrapper[]::new);
            List<PropertiesFile> files = this.myEditor.getResourceBundle().getPropertiesFiles();
            Project project = this.myEditor.getResourceBundle().getProject();
            StructureViewModel model = this.myEditor.getStructureViewComponent().getTreeModel();
            Queue queue = new Queue(1);
            queue.addLast((Object)model.getRoot());
            while (!queue.isEmpty()) {
                TreeElement treeElement = (TreeElement)queue.pullFirst();
                if (treeElement instanceof ResourceBundlePropertyStructureViewElement) {
                    ResourceBundlePropertyStructureViewElement node = (ResourceBundlePropertyStructureViewElement)treeElement;
                    String key = node.getProperty().getKey();
                    LOG.assertTrue(key != null);
                    TreeSet<HighlightInfoType> highlightTypes = new TreeSet<HighlightInfoType>(Comparator.comparing(t -> t.getSeverity(null)));
                    SmartList allDescriptors = new SmartList();
                    IProperty[] properties = (IProperty[])files.stream().map(f -> f.findPropertyByKey(key)).filter(Objects::nonNull).toArray(IProperty[]::new);
                    if (properties.length != 0) {
                        for (InspectionVisitorWrapper v : visitors) {
                            Object[] problemDescriptors = v.getProblemVisitor().apply(properties);
                            if (ArrayUtil.isEmpty((Object[])problemDescriptors)) continue;
                            HighlightSeverity severity = v.getSeverity();
                            for (Object descriptor : problemDescriptors) {
                                allDescriptors.add(Pair.create((Object)descriptor, (Object)v.getKey()));
                                HighlightInfoType infoType = ProblemDescriptorUtil.getHighlightInfoType((ProblemHighlightType)((ResourceBundleEditorProblemDescriptor)descriptor).getHighlightType(), (HighlightSeverity)severity, (SeverityRegistrar)SeverityRegistrar.getSeverityRegistrar((Project)project));
                                highlightTypes.add(infoType);
                            }
                        }
                        node.setInspectedPropertyProblems(allDescriptors.isEmpty() ? null : new InspectedPropertyProblems(allDescriptors.toArray(new Pair[allDescriptors.size()]), highlightTypes));
                    }
                }
                for (TreeElement element : treeElement.getChildren()) {
                    queue.addLast((Object)element);
                }
            }
        }

        public void applyInformationToEditor() {
            this.myEditor.getStructureViewComponent().repaint();
        }

        private /* synthetic */ InspectionVisitorWrapper lambda$collectInformation$1(InspectionProfile profileToUse, PsiFile containingFile, ResourceBundleEditorInspection i) {
            HighlightDisplayKey key = HighlightDisplayKey.find((String)((InspectionProfileEntry)i).getShortName());
            return new InspectionVisitorWrapper(i.buildPropertyGroupVisitor(this.myEditor.getResourceBundle()), profileToUse.getErrorLevel(key, (PsiElement)containingFile).getSeverity(), key);
        }

        private static /* synthetic */ boolean lambda$collectInformation$0(InspectionProfile profileToUse, PsiFile containingFile, InspectionToolWrapper t) {
            return profileToUse.isToolEnabled(HighlightDisplayKey.find((String)t.getShortName()), (PsiElement)containingFile);
        }
    }
}

