/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.IntentionListStep;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.icons.AllIcons;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.editor.ResourceBundlePropertyStructureViewElement;
import com.intellij.lang.properties.editor.inspections.ResourceBundleEditorProblemDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleEditorShowQuickFixesAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(ResourceBundleEditorShowQuickFixesAction.class);

    public ResourceBundleEditorShowQuickFixesAction() {
        super(PropertiesBundle.message("resource.bundle.editor.show.quick.fixes.action.text", new Object[0]));
    }

    public void actionPerformed(AnActionEvent e) {
        Pair<ResourceBundleEditorProblemDescriptor, HighlightDisplayKey>[] descriptorsAndSources;
        ResourceBundleEditor editor = ResourceBundleEditorShowQuickFixesAction.getEditor(e);
        LOG.assertTrue(editor != null);
        ResourceBundlePropertyStructureViewElement element = (ResourceBundlePropertyStructureViewElement)editor.getSelectedElementIfOnlyOne();
        LOG.assertTrue(element != null);
        PsiFile file = editor.getResourceBundle().getDefaultPropertiesFile().getContainingFile();
        ShowIntentionsPass.IntentionsInfo intentions = new ShowIntentionsPass.IntentionsInfo();
        boolean isQuickFixListEmpty = true;
        for (Pair<ResourceBundleEditorProblemDescriptor, HighlightDisplayKey> p : descriptorsAndSources = element.getProblemDescriptors()) {
            ResourceBundleEditorProblemDescriptor d = (ResourceBundleEditorProblemDescriptor)p.getFirst();
            HighlightDisplayKey sourceKey = (HighlightDisplayKey)p.getSecond();
            QuickFix[] fixes = d.getFixes();
            if (fixes == null) continue;
            for (int i = 0; i < fixes.length; ++i) {
                intentions.inspectionFixesToShow.add(new HighlightInfo.IntentionActionDescriptor((IntentionAction)new RBEQuickFixWrapper(d, i), null, null, AllIcons.Actions.IntentionBulb, sourceKey, null, null));
                isQuickFixListEmpty = false;
            }
        }
        if (isQuickFixListEmpty) {
            return;
        }
        Project project = e.getProject();
        LOG.assertTrue(project != null);
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new IntentionListStep(null, intentions, null, file, project)).showInBestPositionFor(e.getDataContext());
    }

    public void update(AnActionEvent e) {
        ResourceBundleEditor editor = ResourceBundleEditorShowQuickFixesAction.getEditor(e);
        e.getPresentation().setEnabledAndVisible(editor != null && editor.getSelectedElementIfOnlyOne() instanceof ResourceBundlePropertyStructureViewElement);
    }

    private static ResourceBundleEditor getEditor(AnActionEvent e) {
        FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(e.getDataContext());
        return editor instanceof ResourceBundleEditor ? (ResourceBundleEditor)editor : null;
    }

    private static class RBEQuickFixWrapper
    implements IntentionAction {
        private final ResourceBundleEditorProblemDescriptor myDescriptor;
        private final int myIndex;

        private RBEQuickFixWrapper(ResourceBundleEditorProblemDescriptor descriptor, int index) {
            this.myDescriptor = descriptor;
            this.myIndex = index;
        }

        @Nls
        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return this.getQuickFix().getFamilyName();
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            QuickFix<ResourceBundleEditorProblemDescriptor> fix = this.getQuickFix();
            ThrowableRunnable fixAction = () -> fix.applyFix(project, (CommonProblemDescriptor)this.myDescriptor);
            if (fix.startInWriteAction()) {
                WriteAction.run((ThrowableRunnable)fixAction);
            } else {
                fixAction.run();
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private QuickFix<ResourceBundleEditorProblemDescriptor> getQuickFix() {
            return this.myDescriptor.getFixes()[this.myIndex];
        }
    }
}

