/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor.inspections;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.properties.editor.inspections.ResourceBundleEditorProblemDescriptor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Pair;
import java.util.SortedSet;
import org.jetbrains.annotations.Nullable;

public class InspectedPropertyProblems {
    private final Pair<ResourceBundleEditorProblemDescriptor, HighlightDisplayKey>[] myDescriptors;
    private final SortedSet<HighlightInfoType> myHighlightTypes;

    public InspectedPropertyProblems(Pair<ResourceBundleEditorProblemDescriptor, HighlightDisplayKey>[] descriptors, SortedSet<HighlightInfoType> types) {
        this.myDescriptors = descriptors;
        this.myHighlightTypes = types;
    }

    public Pair<ResourceBundleEditorProblemDescriptor, HighlightDisplayKey>[] getDescriptors() {
        return this.myDescriptors;
    }

    @Nullable
    public TextAttributes getTextAttributes(EditorColorsScheme scheme) {
        TextAttributes mixedAttributes = null;
        for (HighlightInfoType type : this.myHighlightTypes) {
            TextAttributes current = scheme.getAttributes(type.getAttributesKey());
            if (mixedAttributes == null) {
                mixedAttributes = current;
                continue;
            }
            mixedAttributes = TextAttributes.merge((TextAttributes)mixedAttributes, (TextAttributes)current);
        }
        return mixedAttributes;
    }
}

