/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.parsing;

import com.intellij.lang.Language;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.properties.parsing.PropertiesElementTypes;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.PropertyKeyIndex;
import com.intellij.lang.properties.psi.PropertyStub;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyStubImpl;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.stubs.ILightStubElementType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class PropertyStubElementType
extends ILightStubElementType<PropertyStub, Property> {
    public PropertyStubElementType() {
        super("PROPERTY", (Language)PropertiesElementTypes.LANG);
    }

    public Property createPsi(@NotNull PropertyStub stub) {
        return new PropertyImpl(stub, (IStubElementType)this);
    }

    @NotNull
    public PropertyStub createStub(@NotNull Property psi, StubElement parentStub) {
        return new PropertyStubImpl(parentStub, psi.getKey());
    }

    @NotNull
    public String getExternalId() {
        return "properties.prop";
    }

    public void serialize(@NotNull PropertyStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getKey());
    }

    @NotNull
    public PropertyStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef ref = dataStream.readName();
        return new PropertyStubImpl(parentStub, ref.getString());
    }

    public void indexStub(@NotNull PropertyStub stub, @NotNull IndexSink sink) {
        sink.occurrence(PropertyKeyIndex.KEY, (Object)PropertyImpl.unescape(stub.getKey()));
    }

    public PropertyStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        LighterASTNode keyNode = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)node, (IElementType)PropertiesTokenTypes.KEY_CHARACTERS);
        String key = PropertyStubElementType.intern(tree.getCharTable(), keyNode);
        return new PropertyStubImpl(parentStub, key);
    }

    public static String intern(@NotNull CharTable table, @NotNull LighterASTNode node) {
        assert (node instanceof LighterASTTokenNode) : node;
        return table.intern(((LighterASTTokenNode)node).getText()).toString();
    }
}

